/*
 * Decompiled with CFR 0.152.
 */
package jung.myalghoritm.myGreedyShortestPath;

import edu.uci.ics.jung.algorithms.shortestpath.DijkstraShortestPath;
import edu.uci.ics.jung.graph.Graph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import jung.myalghoritm.MyShortestPath;
import jung.myalghoritm.myGreedyShortestPath.ContextOfOneCrawler;
import org.apache.commons.collections15.Transformer;
import org.apache.log4j.Logger;

public class MyGreedyShortestPath<V, E>
implements MyShortestPath<V, E> {
    private static final Logger log = Logger.getLogger(MyGreedyShortestPath.class);
    protected final Transformer<E, ? extends Number> transformer;
    private final Graph<V, E> graph;
    private long timeLimit = 6700L;

    public MyGreedyShortestPath(Graph<V, E> graph, Transformer<E, ? extends Number> transformer) {
        this.graph = graph;
        this.transformer = transformer;
    }

    public long getTimeLimit() {
        return this.timeLimit;
    }

    public void setTimeLimit(long timeLimit) {
        this.timeLimit = timeLimit;
    }

    @Override
    public List<E> getPath(V source, V target) {
        if (!this.graph.containsVertex(source)) {
            throw new IllegalArgumentException("Specified source vertex " + source + " is not part of graph " + this.graph);
        }
        if (!this.graph.containsVertex(target)) {
            throw new IllegalArgumentException("Specified target vertex " + target + " is not part of graph " + this.graph);
        }
        long startTime = System.currentTimeMillis();
        DijkstraShortestPath dsp = new DijkstraShortestPath(this.graph);
        Number minimalHopN = dsp.getDistance(source, target);
        if (minimalHopN == null) {
            throw new RuntimeException("Path not reachable! Path from " + source + ", to " + target);
        }
        int minimalHop = minimalHopN.intValue();
        ArrayList possiblePaths = new ArrayList();
        HashSet set = new HashSet();
        ContextOfOneCrawler a = new ContextOfOneCrawler(source);
        set.add(a);
        int actualTreshold = minimalHop * 2;
        long time = 0L;
        int i = 0;
        while (possiblePaths.size() < 3 && time < this.timeLimit) {
            --actualTreshold;
            if (++i % 4 == 0) {
                time = System.currentTimeMillis() - startTime;
                log.debug((Object)("Time spent " + time + " ms. Actualy having " + set.size() + " contexts."));
            }
            ArrayList copy = new ArrayList(set);
            set.clear();
            for (ContextOfOneCrawler context : copy) {
                Collection outgoing = this.graph.getOutEdges(context.getActualNode());
                for (Object e : outgoing) {
                    Object newPosition;
                    int thisWouldBe;
                    if (context.getVisitedEdges().contains(e) || (thisWouldBe = dsp.getDistance(newPosition = this.graph.getOpposite(context.getActualNode(), e), target).intValue()) > actualTreshold || set.size() > 150 || !context.shouldGoThere(e, newPosition)) continue;
                    ContextOfOneCrawler newCont = context.getNewFork(e, newPosition, ((Number)this.transformer.transform(e)).doubleValue());
                    if (newCont.getActualNode().equals(target)) {
                        long newPossiblePathTime = System.currentTimeMillis();
                        log.debug((Object)("New possible path found after " + (newPossiblePathTime - startTime) + " ms from start."));
                        possiblePaths.add(newCont);
                        continue;
                    }
                    set.add(newCont);
                }
            }
            if (set.size() != 0 || possiblePaths.size() != 0) continue;
            return new LinkedList();
        }
        if (possiblePaths.size() == 0) {
            return new LinkedList();
        }
        ContextOfOneCrawler<V, E> best = Collections.min(possiblePaths, this.getComparator());
        long endTime = System.currentTimeMillis();
        log.debug((Object)("Path found after " + (endTime - startTime) + " ms."));
        LinkedList path = new LinkedList();
        path = best.getVisitedEdges();
        return path;
    }

    private Comparator<ContextOfOneCrawler<V, E>> getComparator() {
        Comparator navrat = new Comparator<ContextOfOneCrawler<V, E>>(){

            @Override
            public int compare(ContextOfOneCrawler<V, E> o1, ContextOfOneCrawler<V, E> o2) {
                return Double.compare(o1.getDistanceTravlled(), o2.getDistanceTravlled());
            }
        };
        return navrat;
    }
}

