/**
 * 
 */
package sk.stuba.fiit.pogamut.jungigation.worldInfo.objects;

import java.util.Set;
import java.util.Map.Entry;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;

/**
 * @author LuVar
 *
 */
public class SimpleGamerInfo extends ProphetObjectVision<SimpleGamerInfo> {
	private final boolean enemy;
	private final boolean self;
	
	public SimpleGamerInfo(UnrealId id, Set<Entry<Location, Double>> location, boolean enemy, boolean self) {
		super(id, location);
		this.enemy = enemy;
		this.self = self;
	}
	
	/**
	 * <p>
	 * Returns true, if player is enemy.
	 * </p>
	 * 
	 * @return	true, if player is enemy, false otherwise
	 */
	public boolean isEnemy() {
		return enemy;
	}
	
	/**
	 * <p>
	 * Returns true, if informations in this class is from {@link Self} message. Otherwise are informations
	 * obtained from {@link Player} message.
	 * </p>
	 * 
	 * @return
	 */
	public boolean isSelf() {
		return self;
	}
}
