package sk.stuba.fiit.pogamut.jungigation.worldInfo.objects;

import java.util.Set;
import java.util.Map.Entry;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;

/**
 * <p>
 * Holds information about Flag. This class is used in {@link WorldProphet}. It holds also
 * probabilities with positions and {@link WorldProphet} estimates, where flag could be.
 * </p>
 * 
 * @author LuVar
 *
 */
public class SimpleFlagInfo extends ProphetObjectVision<SimpleFlagInfo> {
	private UnrealId holder = null;
	
	public SimpleFlagInfo(UnrealId id, Set<Entry<Location, Double>> location) {
		super(id, location);
	}

	public UnrealId getHolder(){
		return this.holder;
	}
	
	/**
	 * <p>
	 * Sets new holder of flag.
	 * </p>
	 * 
	 * @param holder
	 */
	public void setHolder(UnrealId holder) {
		this.holder = holder;
		this.notifyOfChangeAllListeners();
	}
}
