package sk.stuba.fiit.pogamut.jungigation.worldInfo.objects;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Map.Entry;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;

public abstract class ProphetObjectVision<CONCRETECLASS> extends ProbhetObjectVisionStatic {
	private final List<UpdateListener<CONCRETECLASS>> listeners;

	public ProphetObjectVision(UnrealId id, Set<Map.Entry<Location, Double>> location) {
		super(id, location);
		this.listeners = Collections.synchronizedList(new ArrayList<UpdateListener<CONCRETECLASS>>());
	}

	public void addChangeListener(UpdateListener<CONCRETECLASS> listener) {
		this.listeners.add(listener);
	}

	public void removeChangeListener(UpdateListener<CONCRETECLASS> listener) {
		this.listeners.remove(listener);
	}

	/**
	 * <p>
	 * Will notify all attached listeners about change of this instance.
	 * </p>
	 */
	@SuppressWarnings("unchecked")
	protected void notifyOfChangeAllListeners() {
		if(this.listeners == null) {
			return;
		}
		for (UpdateListener<CONCRETECLASS> listener : this.listeners.toArray(new UpdateListener[this.listeners.size()])) {
			try {
				listener.notifyOfChange((CONCRETECLASS) this);
			} catch (Exception ex) {
				System.err.println("Problem while notifying some of listener! Continuing. Error:" + ex);
				ex.printStackTrace();
			}
		}// end of foreach
	}// end of method notifyOfChangeAllListeners
	
	@Override
	public void setFuzzyLocation(Set<Entry<Location, Double>> location) {
		super.setFuzzyLocation(location);
		this.notifyOfChangeAllListeners();
	}
	
	@Override
	public void setLastSeenTime(double lastSeenTime) {
		super.setLastSeenTime(lastSeenTime);
		this.notifyOfChangeAllListeners();
	}
}
