package sk.stuba.fiit.pogamut.jungigation.transformers;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.collections15.Transformer;
import org.apache.log4j.Logger;

import sk.stuba.fiit.pogamut.jungigation.objects.NavigationGraphSynchronized;
import edu.uci.ics.jung.io.graphml.GraphMLReader2;
import edu.uci.ics.jung.io.graphml.GraphMetadata;

/**
 * <p>
 * Transformer is used while reading navigation graph from file. Instance of this class is given to {@link GraphMLReader2}
 * constructor and than is used to transform attributes grom graphML xml file into instance of {@link NavigationGraphSynchronized}.
 * </p>
 * 
 * @author LuVar
 * 
 * @see GraphMLReader2
 * @see NavigationGraphSynchronized
 */
public class GraphMetadataTransformer implements Transformer<GraphMetadata, NavigationGraphSynchronized> {
    private static final Logger log = Logger.getLogger(GraphMetadata.class);

    public NavigationGraphSynchronized transform(GraphMetadata i) {
	String learningTimeS = i.getProperty(NavigationGraphSynchronized.PROPERTY_LearningTime);
	double learningTime;
	try {
	    learningTime = Double.parseDouble(learningTimeS);
	} catch (Exception ex) {
	    log.warn("GraphMetadataTransformer was unable to read learning time property from saved graph! Using time=0. Error: " + ex.getMessage(), ex);
	    learningTime = 0.0;
	}

	String stucksCountS = i.getProperty(NavigationGraphSynchronized.PROPERTY_StucksCount);
	long stucksCount;
	try {
	    stucksCount = Long.parseLong(stucksCountS);
	} catch (Exception ex) {
	    log.warn("GraphMetadataTransformer was unable to read stucks count property from saved graph! Using stucksCount=0. Error: " + ex.getMessage(), ex);
	    stucksCount = 0;
	}

	String respawnCountS = i.getProperty(NavigationGraphSynchronized.PROPERTY_RespawnCount);
	long respawnCount;
	try {
	    respawnCount = Long.parseLong(respawnCountS);
	} catch (Exception ex) {
	    log.warn("GraphMetadataTransformer was unable to read respawn count property from saved graph! Using respawnCount=0. Error: " + ex.getMessage(), ex);
	    respawnCount = 0;
	}
	
	//copy properties for my requirements
	Map<String, String> prop = new HashMap<String, String>(i.getProperties());
	try {
        	prop.remove(NavigationGraphSynchronized.PROPERTY_LearningTime);
        	prop.remove(NavigationGraphSynchronized.PROPERTY_StucksCount);
        	prop.remove(NavigationGraphSynchronized.PROPERTY_RespawnCount);
	} catch (Exception ex) {
	    log.warn("Unexpected error while removing some properties from additional properties for navigation graph. Ignoring this error. Error:" + ex.getMessage(), ex);
	}
	return new NavigationGraphSynchronized(learningTime, stucksCount, respawnCount, prop);
    }
}
