/**
 * 
 */
package sk.stuba.fiit.pogamut.jungigation.pathPlanners;

import java.util.Collection;
import java.util.List;

import jung.myalghoritm.MyShortestPath;
import sk.stuba.fiit.pogamut.jungigation.objects.MyEdge;
import sk.stuba.fiit.pogamut.jungigation.objects.MyVertice;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathFuture;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathPlanner;
import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import edu.uci.ics.jung.graph.Graph;

/**
 * <p>
 * Class mainly used for subclassing. Second reasonable usage is to make {@link PathPlanner} from any
 * {@link MyShortestPath} class.
 * </p>
 * <p>
 * This nearly abstract class includes just routines for transforming {@link ILocated} instances
 * (from and to) to {@link MyVertice} instances. It also has method {@link #computePath(ILocated)}
 * which only takes target location and "from" location is computed from bot current position.
 * </p>
 * 
 * @author LuVar
 *
 */
public class UniversalPathPlanner implements IPathPlanner<ILocated>, MyShortestPath<MyVertice, MyEdge> {
	private MyShortestPath<MyVertice, MyEdge> shortestPath;
	protected final Graph<MyVertice, MyEdge> navigationGraph;
	@SuppressWarnings("unchecked")
	private final UT2004Bot bot;
	private final Collection<NavPoint> navpoints;

	@SuppressWarnings("unchecked")
	public UniversalPathPlanner(Graph<MyVertice, MyEdge> g, UT2004Bot bot, Collection<NavPoint> navpoints, MyShortestPath<MyVertice, MyEdge> pathPlanner) {
		this.navigationGraph = g;
		this.bot = bot;
		this.navpoints = navpoints;
		this.shortestPath = pathPlanner;
	}

	public MyShortestPath<MyVertice, MyEdge> getShortestPath() {
		return this.shortestPath;
	}

	public void setShortestPath(MyShortestPath<MyVertice, MyEdge> shortestPath) {
		this.shortestPath = shortestPath;
	}

	/**
	 * <p>
	 * If actual location {@link UT2004Bot#getLocation()} is null, {@link EmptyPathHandle} is returned.
	 * </p>
	 */
	public final IPathFuture<ILocated> computePath(ILocated to) {
		ILocated from = this.bot.getLocation();
		if (from == null) {
			return new EmptyPathHandle<ILocated>();
		}
		return this.computePath(from, to);
	}

	public final IPathFuture<ILocated> computePath(ILocated from, ILocated to) {
		if (from == null) {
			return new EmptyPathHandle<ILocated>();
		}
		NavPoint fromN = DistanceUtils.getNearest(this.navpoints, from);
		NavPoint toN;
		if (to instanceof NavPoint) {
			toN = (NavPoint) to;
		} else {
			toN = DistanceUtils.getNearest(this.navpoints, to);
		}
		if (fromN == null || toN == null) {
			//log.warn("FromN or toN is null!!! fromN=" + fromN + ",toN=" + toN);
			throw new RuntimeException("From or To navpoint is null!", new NullPointerException("Could not get nearest nav point. It is null!"));
		}
		List<MyEdge> path;
		path = this.computePathInternal(fromN, toN);
		IPathFuture<ILocated> navrat = new JUNGPathHandle(path, this.navigationGraph, this.navpoints);
		return navrat;
	}

	public List<MyEdge> computePathInternal(NavPoint from, NavPoint to) {
		List<MyEdge> path;
		try {
			path = this.getPath(new MyVertice(from), new MyVertice(to));
		} catch (Exception ex) {
			try {
				Thread.sleep(300);
			} catch (InterruptedException ex1) {
				//log.warn("Interrupted while waiting.", ex);
			}
			path = this.getPath(new MyVertice(from), new MyVertice(to));
		}
		return path;
	}

	/**
	 * <p>
	 * Will compute path from source vertice to target vertice.
	 * </p>
	 * <p>
	 * Will use currently set {@link #shortestPath}. Use {@link #setShortestPath(MyShortestPath)} to
	 * change instance of {@link MyShortestPath} class used to computation of path.
	 * </p>
	 */
	@Override
	public List<MyEdge> getPath(MyVertice source, MyVertice target) {
		return this.shortestPath.getPath(source, target);
	}
}
