package sk.stuba.fiit.pogamut.jungigation.pathPlanners;

import java.util.Collection;

import jung.myalghoritm.MyDijkstraShortestPath;
import sk.stuba.fiit.pogamut.jungigation.objects.MyEdge;
import sk.stuba.fiit.pogamut.jungigation.objects.MyVertice;
import sk.stuba.fiit.pogamut.jungigation.pathPlanners.helpers.EdgeAndVertexToNumberAdvancedTransformer;
import sk.stuba.fiit.pogamut.jungigation.transformers.EdgeToTimeNumberTransformer;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import edu.uci.ics.jung.graph.Graph;

/**
 * <p>
 * Allows path planning based on some preferences, to obtain items thru planned path. There are some predefined profiles
 * for preferences, but you can add any number of preferences or overwrite default one.
 * </p>
 * <p>
 * Profiles are called by string names. Default profiles had its names in static properties like {@link #HEALTHINTEREST}
 * or {@link #ARMORINTEREST}. To set active profile use {@link #getTransformer()} method and on returned object
 * call {@link EdgeAndVertexToNumberAdvancedTransformer#setActiveProfile(String)} method.
 * </p>
 * 
 * @author LuVar
 * 
 */
public class AdvancedPathPlanner extends SimplestDijkstraPathPlanner {
	//private EdgeAndVertexToNumberAdvancedTransformer transformer;
	private EdgeToTimeNumberTransformer transformer;

	/**
	 * <p>
	 * Constructs {@link AdvancedPathPlanner} with some default profiles of path planning. Default active path planning
	 * profile is {@link #JUSTTIMEINTEREST}.
	 * </p>
	 * 
	 * @param navigationGraph
	 * @param bot
	 * @param navpoints
	 */
	@SuppressWarnings("unchecked")
	public AdvancedPathPlanner(Graph<MyVertice, MyEdge> navigationGraph, UT2004Bot bot, Collection<NavPoint> navpoints) {
		super(navigationGraph, bot, navpoints, null);

		//this.transformer = new EdgeAndVertexToNumberAdvancedTransformer(navigationGraph);
		this.transformer = new EdgeToTimeNumberTransformer();

		// TODO overwriting existing instance... bad thing
		// this.spp = new FloydWarshallShortestPath<MyVertice, MyEdge>(this.navigationGraph, this.transformer, false);
		this.setShortestPath(new MyDijkstraShortestPath(this.navigationGraph, this.transformer, false));
	}// end of constructor

	//public EdgeAndVertexToNumberAdvancedTransformer getTransformer() {
	public EdgeToTimeNumberTransformer getTransformer() {
		return this.transformer;
	}
}
