package sk.stuba.fiit.pogamut.jungigation.objects;

import java.util.ArrayList;
import java.util.Collections;
import java.util.StringTokenizer;

import sk.stuba.fiit.pogamut.jungigation.transformers.SerializableByTransformer;

/**
 *
 * @author LuVar
 */
public class MyEdge implements SerializableByTransformer {

    /**
     * <p>
     * Times taken to travel this edge.
     * </p>
     */
    private ArrayList<Double> times = new ArrayList<Double>();

    private String id;

    /**
     * <p>
     * Id of {@link MyEdge} is generated by this code:
     * <code>this.id = idFrom + "->" + idTo;</code>.
     * </p>
     * 
     * @param idFrom
     * @param idTo
     */
    public MyEdge(String id) {
	this.id = id;
    }

    public MyEdge(String id, double time) {
	this.id = id;
	this.times.add(time);
	this.travelTimeComputed = time;
    }

    public MyEdge(String serializedID, String arraylist) {
	this.id = serializedID;
	this.deserialize(arraylist);
    }

    public MyEdge(double travelTime, int countOfTraveling) {
	for (int i = 0; i < countOfTraveling; i++) {
	    this.times.add(travelTime);
	}
	this.travelTimeComputed = 0.0;
    }

    public void addNewTravelTime(double time) {
	this.times.add(time);
	this.travelTimeComputed = 0.0;
    }

    /**
     * <p>
     * Do NOT modify returned array! It is not a copy, it is original internal
     * storrage of informations!
     * </p>
     * @return
     */
    public ArrayList<Double> getAllTravelTimes() {
	return this.times;
    }

    private double travelTimeComputed = 0.0;

    /**
     * <p>
     * Returns median of traveling times.
     * </p>
     *
     * @return
     */
    public double getTravelTime() {
	if(this.travelTimeComputed != 0.0) {
	    return this.travelTimeComputed;
	}
	Collections.sort(this.times);
	int count = this.times.size();
	if (count == 0) {
	    return Double.NaN;
	}
	if (count == 1) {
	    return this.times.get(0);
	}
	this.travelTimeComputed = median(this.times.toArray(new Double[count]));
	return this.travelTimeComputed;
    }

    public int getNumberOfTravelsInArray() {
	return this.times.size();
    }

    /**
     * <p>
     * From http://leepoint.net/notes-java/data/arrays/30arraysExamples.html
     * </p>
     * <p>
     * Precondition: Array must be sorted
     * </p>
     *
     * @param m     sorted array
     * @return      median of array data
     */
    public static double median(Double[] m) {
	int middle = m.length / 2;  // subscript of middle element
	if (m.length % 2 == 1) {
	    // Odd number of elements -- return the middle one.
	    return m[middle];
	} else {
	    // Even number -- return average of middle two
	    // Must cast the numbers to double before dividing.
	    return (m[middle - 1] + m[middle]) / 2.0;
	}
    }//end method median

    @Override
    public boolean equals(Object obj) {
	return super.equals(obj);
    }//end of method equals

    @Override
    public String toString() {
	String a = this.id;	//super.toString();
	return "MyEdge(" + a + "):" + this.getTravelTime();
    }

    /*@Override
    public int hashCode() {
	return 0;
    }*/

    public String serialize() {
	String navrat = "";
	navrat += this.times.size();
	navrat += "#";
	for (Double time : this.times) {
	    time = Math.round(time * 1000.0) / 1000.0;
	    navrat += time;
	    navrat += "#";
	}
	return navrat;
    }

    public void deserialize(String data) {
	StringTokenizer st = new StringTokenizer(data, "#");
	String countS = st.nextToken();

	int count;
	try {
	    count = Integer.parseInt(countS);
	} catch (Exception ex) {
	    throw new RuntimeException("Error while parsing stored edge data count from text (data=" + data + ")! Error:" + ex.getMessage(), ex);
	}

	this.times.clear();
	for (int j = 0; j < count; j++) {
	    try {
		this.addNewTravelTime(Double.parseDouble(st.nextToken()));
	    } catch (Exception ex) {
		throw new RuntimeException("Error while parsing stored edge data (times) from text (data=" + data + ")! Error:" + ex.getMessage(), ex);
	    }
	}
    }//end of method deserialize

    public String getId() {
	return this.id;
    }
}
