package jung.myalghoritm.myDepthSearch;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;

import jung.myalghoritm.MyShortestPath;

import org.apache.commons.collections15.Transformer;
import org.apache.log4j.Logger;

import sk.stuba.fiit.pogamut.jungigation.objects.MyEdge;
import sk.stuba.fiit.pogamut.jungigation.objects.MyVertice;
import edu.uci.ics.jung.graph.Graph;

/**
 * <p>
 * http://en.wikipedia.org/wiki/Depth-first_search
 * </p>
 * 
 * @author LuVar
 * 
 */
public class DepthFirstSearchPathPlanner implements MyShortestPath<MyVertice, MyEdge> {
	private static final Logger log = Logger.getLogger(DepthFirstSearchPathPlanner.class);

	protected final Transformer<MyEdge, ? extends Number> transformer;
	private final Graph<MyVertice, MyEdge> graph;

	public DepthFirstSearchPathPlanner(Graph<MyVertice, MyEdge> graph, Transformer<MyEdge, ? extends Number> transformer) {
		this.graph = graph;
		this.transformer = transformer;
	}

	@Override
	public List<MyEdge> getPath(MyVertice source, MyVertice target) {
		log.debug("Going to compute path from " + source + " to " + target + ".");
		return runDFSmain(source, target);
	}

	private int vertexCount = -4;
	MyVertice vertices[] = null;
	MyVertice source = null;
	MyVertice target = null;

	public List<MyEdge> runDFSmain(MyVertice source, MyVertice target) {
		this.source = source;
		this.target = target;
		this.vertexCount = this.graph.getVertexCount();
		Collection<MyVertice> vert = this.graph.getVertices();
		this.vertices = vert.toArray(new MyVertice[this.vertexCount]);

		int sourceVertexIndex = -1;
		for (int i = 0; i < this.vertexCount; i++) {
			if(source.equals(this.vertices[i])) {
				sourceVertexIndex = i;
			}
		}
		//swap start vertext with first vertex
		MyVertice pom = this.vertices[0];
		this.vertices[0] = this.vertices[sourceVertexIndex];
		this.vertices[sourceVertexIndex] = pom;
		//STart depth frst from first vertex, which is now source.
		List<MyEdge> vratene = runDFS(0, new Stack<Integer>());
		//TODO find best path, or so... It is possible to prune result list earlier...
		if(vratene == null || vratene.size() == 0) {
			throw new RuntimeException("Path not reachable! Path from " + source + ", to " + target);
		}
		return vratene;
	}

	private List<MyEdge> runDFS(int u, Stack<Integer> currentPath) {
		if(currentPath.contains(u)) {
			return null;
		}
		currentPath.push(u);

		MyVertice uv = this.vertices[u];

		List<MyEdge> navrat = new LinkedList<MyEdge>();

		for (int v = 0; v < this.vertexCount; v++) {
			if(u == v) {
				continue;
			}
			MyVertice vv = this.vertices[v];
			//if (isEdge(u, v) && state[v] == VertexState.White) {
			log.trace("Going to examine edge from " + uv.getId() + " to " + vv.getId() + ".");
			//if (state[v] != VertexState.White && this.graph.isSuccessor(uv, vv)) {
			if (this.graph.isSuccessor(uv, vv)) {
				if(vv.equals(this.target)) {
					log.debug("Found first path to target.");
					List<MyEdge> path = new LinkedList<MyEdge>();
					path.add(this.graph.findEdge(uv, vv));
					return path;
				} else {//end of if v is reference to target
					List<MyEdge> vratene = runDFS(v, currentPath);
					if(vratene != null) {
						//add edge from current vertice to vertice which was given to runDFS method
						vratene.add(0, this.graph.findEdge(uv, vv));
						return vratene;
					}//end of if vratene is not null
				}//end else block for if v is reference to target
			}//end of if there is connection from vv to uv vertice.
		}

		currentPath.pop();
		return navrat;
	}
}
