/**
 * 
 */
package jung.myalghoritm;

import java.util.List;
import java.util.Map;

import edu.uci.ics.jung.algorithms.shortestpath.DijkstraShortestPath;
import edu.uci.ics.jung.algorithms.shortestpath.ShortestPath;

/**
 * <p>
 * Calculates distances and shortest paths using Bellman–Ford's single-source-shortest-path algorithm. This algorithm
 * accepts also negative weights on edges, which {@link DijkstraShortestPath} doesn't. For graphs without negative edges
 * weights could be slower than {@link DijkstraShortestPath}.
 * </p>
 * <p>
 * Implemented by reading wiki {@link http://en.wikipedia.org/wiki/Bellman-Ford_algorithm} and blog with sample C
 * implementation {@link http ://compprog.wordpress.com/2007/11/29/one-source-shortest-path-the-bellman-ford-algorithm/}
 * . It runs in O(VE) time - relaxations number. This mean that if you have large graph with many edges, it will be
 * slow. This algorithm is ideal for spare graphs.
 * </p>
 * <p>
 * Note, this algorithm can detect negative cycles, but cannot work with them.
 * </p>
 * 
 * @author LuVar - luvar@plaintext.sk
 * 
 * @see DijkstraShortestPath
 */
public class BellmanFordShortestPath<V, E> implements ShortestPath<V, E>, MyShortestPath<V, E> {

    @Override
    public Map<V, E> getIncomingEdgeMap(V source) {
	// TODO Auto-generated method stub
	return null;
    }

    @Override
    public List<E> getPath(V source, V target) {
	// TODO Auto-generated method stub
	return null;
    }
}
