package jung.myalghoritm.AStar;

import java.util.*;

import jung.myalghoritm.MyShortestPath;
import jung.myalghoritm.dynamicWeigths.EdgeAndVertexToNumberWeightTransformer;

import org.apache.log4j.Logger;

import edu.uci.ics.jung.graph.Graph;

public abstract class AbstractAStarPathPlanner<V, E> implements MyShortestPath<V, E> {
	private static final Logger log = Logger.getLogger(AbstractAStarPathPlanner.class);

	protected final Graph<V, E> g;

	public final int implementation;

	public AbstractAStarPathPlanner(Graph<V, E> navigationGraph, EdgeAndVertexToNumberWeightTransformer<V, E> transformer, int implementation) {
		this.g = navigationGraph;
		this.implementation = implementation;
	}

	//@Override
	//public abstract List<E> getPath(V from, V to);

	public abstract Double heuristicEstimateOfDistance(V a, V b);
	public abstract Double distanceBetween(V a, V b);

	@Override
	public List<E> getPath(V from, V to) {
		Map<V, VerticeForAStar<V>> closedMap = new HashMap<V, VerticeForAStar<V>>(); // The set of nodes already evaluated.
		SortedSet<VerticeForAStar<V>> opensetSorted = new TreeSet<VerticeForAStar<V>>(new VerticeForAStarComparator<V>()); // The set of tentative nodes to be evaluated.
		//set containing the initial node
		VerticeForAStar<V> fromV = new VerticeForAStar<V>(from);
		opensetSorted.add(fromV);
		Map<VerticeForAStar<V>,VerticeForAStar<V>> came_from = new HashMap<VerticeForAStar<V>, VerticeForAStar<V>>(); // The map of navigated nodes.

		double estimation = heuristicEstimateOfDistance(from, to);
		fromV.f_score = estimation;
		fromV.h_score = estimation;

		boolean tentative_is_better;
		int i = 0;

		VerticeForAStar<V> goal = null;
		switch (this.implementation) {
		case 0:
			//http://code.google.com/p/jianwikis/wiki/AStarAlgorithmForPathPlanning
			PriorityQueue<VerticeForAStar<V>> pQueue = new PriorityQueue<VerticeForAStar<V>>(40, new VerticeForAStarComparator<V>());
			pQueue.add(fromV);
			//http://en.wikipedia.org/w/index.php?title=A*_search_algorithm&oldid=400388559#Pseudocode -> http://en.wikipedia.org/wiki/A*_search_algorithm#Pseudocode
			while(!pQueue.isEmpty()) {
				i++;
				//				log.trace("ASttar iteration: " + i + ", #openset: " + pQueue.size() + ", #closedset: " + closedMap.size());
				VerticeForAStar<V> x = pQueue.poll(); //the node in openset having the lowest f_score value
				if(x.vertice.equals(to)) {
					List<V> path = reconstruct_path(new VerticeForAStar<V>(from), new VerticeForAStar<V>(to), came_from);
					return convertPathRepresentation(path);
				}
				pQueue.remove(x);
				closedMap.put(x.vertice, x);
				Collection<V> neighbors = this.g.getSuccessors(x.vertice);
				for (V yy : neighbors) {
					VerticeForAStar<V> y = closedMap.get(yy);
					if(y != null) {
						continue;
					} else {
						y = new VerticeForAStar<V>(yy);
					}
					double tentative_g_score = x.g_score + distanceBetween(x.vertice, y.vertice);

					if(!pQueue.contains(y)) {
						pQueue.add(y);
						tentative_is_better = true;
					} else if(tentative_g_score < y.g_score) {
						tentative_is_better = true;
					} else {
						tentative_is_better = false;
					}

					if(tentative_is_better == true) {
						//before changing value used for comparing I remove object from set and than add...
						pQueue.remove(y);
						y.g_score = tentative_g_score;
						y.h_score = heuristicEstimateOfDistance(y.vertice, to);
						y.f_score = y.g_score + y.h_score;
						pQueue.add(y);

						came_from.put(y, x);
					}
				}// end of foreach v in this.g.getNeighbors(x.vertice)
			}
			return null;
		case 1:
			//http://code.google.com/p/jianwikis/wiki/AStarAlgorithmForPathPlanning
			while(!opensetSorted.isEmpty()){
				VerticeForAStar<V> x = opensetSorted.first();
				opensetSorted.remove(x);
				if(x.vertice.equals(to)){
					//found
					if(log.isDebugEnabled()){
						//log.debug("Found target node " + x);
					}
					goal = x;
					break;
				}else{
					if(log.isDebugEnabled()){
						//log.debug("Search for node " + x);
					}
					closedMap.put(x.vertice, x);
					Collection<V> neighbors = this.g.getSuccessors(x.vertice);
					for (V neighbor2 : neighbors) {
						VerticeForAStar<V> visited = closedMap.get(neighbor2);
						if (visited == null) {
							double g = x.g_score + this.distanceBetween(x.vertice, neighbor2);

							//VerticeForAStar<V> n = opensetSorted.get(visited);
							VerticeForAStar<V> n = new VerticeForAStar<V>(neighbor2);
							if (!opensetSorted.contains(visited)) {
								//not in the open set
								n.g_score =  g;
								n.f_score = this.heuristicEstimateOfDistance(neighbor2, to);
								n.h_score = n.f_score;
								//n.setCameFrom(x);
								came_from.put(n, x);
								opensetSorted.add(n);
								//pQueue.add(n);
							} else if (g < n.g_score) {
								opensetSorted.remove(n);
								//Have a better route to the current node, change its parent
								//n.setCameFrom(x);
								came_from.put(n, x);
								n.g_score = g;
								n.h_score = this.heuristicEstimateOfDistance(neighbor2, to);
								n.h_score = n.f_score;
								opensetSorted.add(n);
							}
						}//end of visited == null
					}//end of foreach neighbor2 in neighbors
				}//end of else if x.equals(to)
			}//end of while

			//after found the target, start to construct the path
			if(goal != null) {
				Stack<V> stack = new Stack<V>();
				List<V> list = new ArrayList<V>();
				stack.push(goal.vertice);
				VerticeForAStar<V> parent = came_from.get(goal);
				while(parent != null){
					stack.push(parent.vertice);
					parent = came_from.get(parent);
				}
				if (log.isDebugEnabled()) {
					//log.debug("Constructing search path: ");
				}
				while(stack.size() > 0){
					if (log.isDebugEnabled()) {
						//log.debug("\t" + stack.peek());
					}
					list.add(stack.pop());
				}
				return convertPathRepresentation(list);
			}
			return null;
		case 2:
			//http://en.wikipedia.org/w/index.php?title=A*_search_algorithm&oldid=400388559#Pseudocode -> http://en.wikipedia.org/wiki/A*_search_algorithm#Pseudocode
			while(!opensetSorted.isEmpty()) {
				i++;
				//				log.trace("ASttar iteration: " + i + ", #openset: " + opensetSorted.size() + ", #closedset: " + closedMap.size());
				VerticeForAStar<V> x = opensetSorted.first(); //the node in openset having the lowest f_score value
				if(x.vertice.equals(to)) {
					List<V> path = reconstruct_path(new VerticeForAStar<V>(from), new VerticeForAStar<V>(to), came_from);
					return convertPathRepresentation(path);
				}
				opensetSorted.remove(x);
				closedMap.put(x.vertice, x);
				Collection<V> neighbors = this.g.getSuccessors(x.vertice);
				for (V yy : neighbors) {
					VerticeForAStar<V> y = closedMap.get(yy);
					if(y != null) {
						continue;
					} else {
						y = new VerticeForAStar<V>(yy);
					}
					double tentative_g_score = x.g_score + distanceBetween(x.vertice, y.vertice);

					if(!opensetSorted.contains(y)) {
						opensetSorted.add(y);
						tentative_is_better = true;
					} else if(tentative_g_score < y.g_score) {
						tentative_is_better = true;
					} else {
						tentative_is_better = false;
					}

					if(tentative_is_better == true) {
						//before changing value used for comparing I remove object from set and than add...
						opensetSorted.remove(y);
						y.g_score = tentative_g_score;
						y.h_score = heuristicEstimateOfDistance(y.vertice, to);
						y.f_score = y.g_score + y.h_score;
						opensetSorted.add(y);

						came_from.put(y, x);
					}
				}// end of foreach v in this.g.getNeighbors(x.vertice)
			}
			return null;
		case 3:
			//http://en.wikipedia.org/w/index.php?title=A*_search_algorithm&oldid=400388559#Pseudocode -> http://en.wikipedia.org/wiki/A*_search_algorithm#Pseudocode

			while(!opensetSorted.isEmpty()) {
				i++;
				//				log.trace("ASttar iteration: " + i + ", #openset: " + opensetSorted.size() + ", #closedset: " + closedMap.size());
				VerticeForAStar<V> x = opensetSorted.first(); //the node in openset having the lowest f_score value
				if(x.vertice.equals(to)) {
					List<V> path = reconstruct_path(new VerticeForAStar<V>(from), new VerticeForAStar<V>(to), came_from);
					return convertPathRepresentation(path);
				}
				opensetSorted.remove(x);
				closedMap.put(x.vertice, x);
				Collection<V> neighbors = this.g.getSuccessors(x.vertice);
				for (V yy : neighbors) {
					VerticeForAStar<V> y = closedMap.get(yy);
					if(y != null) {
						continue;
					} else {
						y = new VerticeForAStar<V>(yy);
					}
					double tentative_g_score = x.g_score + distanceBetween(x.vertice, y.vertice);

					if(!opensetSorted.contains(y)) {
						opensetSorted.add(y);
						tentative_is_better = true;
					} else if(tentative_g_score < y.g_score) {
						tentative_is_better = true;
					} else {
						tentative_is_better = false;
					}

					if(tentative_is_better == true) {
						//before changing value used for comparing I remove object from set and than add...
						opensetSorted.remove(y);
						y.g_score = tentative_g_score;
						y.h_score = heuristicEstimateOfDistance(y.vertice, to);
						y.f_score = y.g_score + y.h_score;
						opensetSorted.add(y);

						if(came_from.get(y) != null) {
							if( x.f_score < came_from.get(y).f_score) {
								came_from.put(y, x);
							}
						} else {
							came_from.put(y, x);
						}
					}
				}// end of foreach v in this.g.getNeighbors(x.vertice)
			}
			return null;
		default:
			throw new RuntimeException("unknown implementation code! implementation=" + this.implementation);
		}
	}

	protected List<V> reconstruct_path(VerticeForAStar<V> came_from, VerticeForAStar<V> current_node, Map<VerticeForAStar<V>,VerticeForAStar<V>> came_from_map) {
		List<V> navrat;

		VerticeForAStar<V> currentNodeCameFrom = came_from_map.get(current_node);
		if(currentNodeCameFrom != null) {// && currentNodeCameFrom.vertice != null) {
			navrat = reconstruct_path(came_from, came_from_map.get(current_node), came_from_map);
			navrat.add(current_node.vertice);
			return navrat;
		} else {
			navrat = new LinkedList<V>();
			navrat.add(current_node.vertice);
			return navrat;
		}
	}

	protected List<E> convertPathRepresentation(List<V> path) {
		int length = path.size();
		length--;
		List<E> navrat = new ArrayList<E>(length);
		for(int i = 0; i < length; i++) {
			V v1 = path.get(i);
			V v2 = path.get(i+1);
			navrat.add(this.g.findEdge(v1, v2));
		}
		return navrat;
	}

	@Override
	public String toString() {
		return "AbstractAStarPathPlanner(impl:" + this.implementation + ")";
	}
}
