/*
 * Decompiled with CFR 0.152.
 */
package sk.stuba.fiit.pogamut.jungigation.transformers;

import edu.uci.ics.jung.io.graphml.GraphMetadata;
import java.util.HashMap;
import org.apache.commons.collections15.Transformer;
import org.apache.log4j.Logger;
import sk.stuba.fiit.pogamut.jungigation.objects.NavigationGraphSynchronized;

public class GraphMetadataTransformer
implements Transformer<GraphMetadata, NavigationGraphSynchronized> {
    private static final Logger log = Logger.getLogger(GraphMetadata.class);

    public NavigationGraphSynchronized transform(GraphMetadata i) {
        long respawnCount;
        long stucksCount;
        double learningTime;
        String learningTimeS = i.getProperty("LearningTime");
        try {
            learningTime = Double.parseDouble(learningTimeS);
        }
        catch (Exception ex) {
            log.warn((Object)("GraphMetadataTransformer was unable to read learning time property from saved graph! Using time=0. Error: " + ex.getMessage()), (Throwable)ex);
            learningTime = 0.0;
        }
        String stucksCountS = i.getProperty("StucksCount");
        try {
            stucksCount = Long.parseLong(stucksCountS);
        }
        catch (Exception ex) {
            log.warn((Object)("GraphMetadataTransformer was unable to read stucks count property from saved graph! Using stucksCount=0. Error: " + ex.getMessage()), (Throwable)ex);
            stucksCount = 0L;
        }
        String respawnCountS = i.getProperty("RespawnCount");
        try {
            respawnCount = Long.parseLong(respawnCountS);
        }
        catch (Exception ex) {
            log.warn((Object)("GraphMetadataTransformer was unable to read respawn count property from saved graph! Using respawnCount=0. Error: " + ex.getMessage()), (Throwable)ex);
            respawnCount = 0L;
        }
        HashMap<String, String> prop = new HashMap<String, String>(i.getProperties());
        try {
            prop.remove("LearningTime");
            prop.remove("StucksCount");
            prop.remove("RespawnCount");
        }
        catch (Exception ex) {
            log.warn((Object)("Unexpected error while removing some properties from additional properties for navigation graph. Ignoring this error. Error:" + ex.getMessage()), (Throwable)ex);
        }
        return new NavigationGraphSynchronized(learningTime, stucksCount, respawnCount, prop);
    }
}

