package sk.stuba.fiit.pogamut.jungigation.worldInfo.objectsCache;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import sk.stuba.fiit.pogamut.jungigation.worldInfo.AdvancedSharedItems;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.SharedItems;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.snapshoot.SelfSnapshot;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectListener;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AdvancedItems;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Items;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;

/**
 * <p>
 * TODO Should not extends from {@link PlayersCache} ?
 * </p>
 * 
 * @author LuVar
 * 
 */
public class SelfCache extends AbstractNotifiableCache<Self> {
	private Map<IWorldView, SelfListener> listeners = new HashMap<IWorldView, SelfListener>();
	private Map<UnrealId, List<SelfSnapshot>> selfsHistory = Collections.synchronizedMap(new HashMap<UnrealId, List<SelfSnapshot>>());
	
	public static final int HISTORYSIZE = 20;
	
	/**
	 * <p>
	 * For similar functionality look in see section.
	 * </p>
	 * <p>
	 * TODO look also for player left and team changed events...
	 * </p>
	 * 
	 * @param worldView
	 * 
	 * @see FlagsCache
	 * @see ItemsCache
	 * @see SharedItems
	 * @see AdvancedSharedItems
	 * @see Items
	 * @see AdvancedItems
	 */
	public SelfCache(IWorldView worldView) {
		SelfListener tmp = new SelfListener();
		this.listeners.put(worldView, tmp);
		worldView.addObjectListener(Self.class, tmp);
	}
	
	/**
	 * @see sk.stuba.fiit.LuVar.pogamut.jungigation.worldInfo.objectsCache.CacheInterface#addAnotherViewer(cz.cuni.amis.pogamut.base.communication.worldview.IWorldView)
	 */
	public void addAnotherViewer(IWorldView worldView) {
		SelfListener tmp = new SelfListener();
		this.listeners.put(worldView, tmp);
		worldView.addObjectListener(Self.class, tmp);
	}
	
	/**
	 * @see sk.stuba.fiit.LuVar.pogamut.jungigation.worldInfo.objectsCache.CacheInterface#removeViewer(cz.cuni.amis.pogamut.base.communication.worldview.IWorldView)
	 */
	public void removeViewer(IWorldView worldView) {
		SelfListener tmp = this.listeners.get(worldView);
		this.listeners.remove(worldView);
		worldView.removeObjectListener(Self.class, tmp);
	}
	
	/**
	 * <p>
	 * Returns list of last known states for desired item. Returned list is unmodifiable.
	 * </p>
	 * 
	 * @param id
	 * @return
	 */
	public List<SelfSnapshot> getSelfHistory(UnrealId id) {
		return Collections.unmodifiableList(this.selfsHistory.get(id));
	}
	
	/**
	 * <p>
	 * Whole items history. Unmodifiable.
	 * </p>
	 * 
	 * @return
	 */
	public Map<UnrealId, List<SelfSnapshot>> getSelfsHistory() {
		return Collections.unmodifiableMap(this.selfsHistory);
	}
	
	@Override
	protected void notify(Self event) {
		super.notify(event);
		List<SelfSnapshot> oneItemHistory = this.selfsHistory.get(event.getId());
		if (oneItemHistory == null) {
			// TODO choose best implementation of list or code own, synchronized
			oneItemHistory = Collections.synchronizedList(new LinkedList<SelfSnapshot>());
			this.selfsHistory.put(event.getId(), oneItemHistory);
		}// end of if itemHistory == null
		oneItemHistory.add(0, new SelfSnapshot(event));
		// keep just last 20 item states
		while (oneItemHistory.size() > SelfCache.HISTORYSIZE) {
			oneItemHistory.remove(SelfCache.HISTORYSIZE);
		}
	}
	
	private class SelfListener implements IWorldObjectListener<Self> {
		@Override
		public void notify(IWorldObjectEvent<Self> event) {
			SelfCache.this.notify(event.getObject());
		}// end of method notify
	}// end of private class ItemsCache
}
