/**
 * 
 */
package sk.stuba.fiit.pogamut.jungigation.pathPlanners;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Map.Entry;

import sk.stuba.fiit.pogamut.jungigation.objects.MyEdge;
import sk.stuba.fiit.pogamut.jungigation.objects.MyVertice;
import sk.stuba.fiit.pogamut.jungigation.objects.NavigationGraphSynchronized;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import edu.uci.ics.jung.algorithms.shortestpath.DijkstraDistance;

/**
 * <p>
 * This class provides informations from navigations data. It is useful for getting nearest health-pack, or just getting
 * some random location near somewhere.
 * </p>
 * 
 * @author LuVar
 * 
 */
public class MapExpert {
    private final NavigationGraphSynchronized navGraph;

    private final Random rnd = new Random();

    public MapExpert(NavigationGraphSynchronized navGraph) {
	this.navGraph = navGraph;
    }

    /**
     * <p>
     * Will compute all reachable {@link Location} from given location in given time in seconds (UT game seconds). From
     * this set of all reachable {@link Location}, will be randomly chosen one and returned.
     * </p>
     * <p>
     * Note that {@link Location}-s should be always same as {@link NavPoint}-s in map.
     * </p>
     * 
     * @param loc location from which to find
     * @param maxTime maximum allowed time from location
     * @return random {@link Location} within given constraints
     */
    public Location getRandomPointWithinTime(Location loc, double maxTime) {
	// TODO implement this normally
	DijkstraDistance<MyVertice, MyEdge> a = new DijkstraDistance<MyVertice, MyEdge>(this.navGraph);
	MyVertice source = this.navGraph.getVerticeFromLocation(loc);
	Map<MyVertice, Number> distances = a.getDistanceMap(source);
	ArrayList<MyVertice> possibleTargets = new ArrayList<MyVertice>((distances.size() / 10));
	for (Entry<MyVertice, Number> dist : distances.entrySet()) {
	    if (dist.getValue().doubleValue() <= maxTime) {
		possibleTargets.add(dist.getKey());
	    }
	}
	int max = possibleTargets.size();
	int randomIndex = this.rnd.nextInt(max);
	return possibleTargets.get(randomIndex).getLocation();
    }

    /**
     * TODO this should be saved in graph!
     * 
     * @param myTeam
     * @return
     */
    public Location getEnemyFlagHome(int myTeam) {
	switch (myTeam) {
	case AgentInfo.TEAM_BLUE:
	    myTeam = AgentInfo.TEAM_RED;
	    break;
	case AgentInfo.TEAM_RED:
	    myTeam = AgentInfo.TEAM_BLUE;
	    break;
	default:
	    throw new RuntimeException("Unknown team!");
	}
	String team = this.getTeamString(myTeam);
	for (MyVertice vert : this.navGraph.getVertices()) {
	    String lowercasename = vert.getId().getStringId().toLowerCase();
	    if (lowercasename.contains("flag") && lowercasename.contains(team)) {
		return vert.getLocation();
	    }
	}
	throw new RuntimeException("Enemy flag home could not be found. Searching for navpoint which have \"" + team + "\" and \"flag\" in name.");
    }

    public Location getMyFlagHome(int myTeam) {
	String team = this.getTeamString(myTeam);
	for (MyVertice vert : this.navGraph.getVertices()) {
	    String lowercasename = vert.getId().getStringId().toLowerCase();
	    if (lowercasename.contains("flag") && lowercasename.contains(team)) {
		return vert.getLocation();
	    }
	}
	throw new RuntimeException("Enemy flag home could not be found. Searching for navpoint which have \"" + team + "\" and \"flag\" in name.");
    }

    private String getTeamString(int team) {
	String color;
	switch (team) {
	case AgentInfo.TEAM_BLUE:
	    color = "blue";
	    break;
	case AgentInfo.TEAM_RED:
	    color = "red";
	    break;
	default:
	    throw new RuntimeException("Unknown team!");
	}
	return color;
    }

    /**
     * <p>
     * Extracts spawn points from navigation map for desired team.
     * </p>
     * <p>
     * Note, that if map is DM, it gives team 0 to all spawn points. If map is CTF, it will have spawn points 0 and 1.
     * Look at {@link AgentInfo#TEAM_RED} and {@link AgentInfo#TEAM_BLUE}.
     * </p>
     * 
     * @param team
     * @return
     */
    public List<MyVertice> getAllSpawnsForTeam(int team) {
	List<MyVertice> navrat = new ArrayList<MyVertice>();
	for (MyVertice v : this.navGraph.getVertices().toArray(new MyVertice[this.navGraph.getVertexCount()])) {
	    if (v.getSpawnFor() == team) {
		navrat.add(v);
	    }
	}// end of foreach v in this.navGraph.getVertices().toArray(new MyVertice[this.navGraph.getVertexCount()])
	return navrat;
    }
}
