/**
 * 
 */
package sk.stuba.fiit.pogamut.jungigation.pathPlanners.helpers;

import java.util.Collection;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import sk.stuba.fiit.pogamut.jungigation.objects.MyVertice;

/**
 * @author LuVar
 *
 */
public class LocationToVerticeFinder {
	private final Collection<MyVertice> vertices;
	
	public LocationToVerticeFinder(Collection<MyVertice> vertices) {
		this.vertices = vertices;
	}
	
	public MyVertice findVerticeByLocation(Location location) {
		MyVertice nearestVertice = null;
		double minDistance = Double.MAX_VALUE;
		double d;
		for (MyVertice vert : this.vertices) {
			d = vert.getLocation().getDistance(location);
            if(d < minDistance) {
                minDistance = d;
                nearestVertice = vert;
                if(minDistance == 0) {
                	//Found exact distance
                	return nearestVertice;
                }
            }
		}//end of foreach vertice in vertices
		if(minDistance > 100) {
			throw new RuntimeException("Nearest vertice was too far. Distance=" + minDistance + ",desiredLocation=" + location + ".");
		}
		return nearestVertice;
	}//end of method findVerticeByLocation
}
