/**
 * 
 */
package jung.myalghoritm.myGreedyShortestPath;

import java.util.*;

import jung.myalghoritm.MyShortestPath;

import org.apache.commons.collections15.Transformer;
import org.apache.log4j.Logger;

import edu.uci.ics.jung.algorithms.shortestpath.DijkstraShortestPath;
import edu.uci.ics.jung.graph.Graph;

/**
 * <p>
 * Some blind, bruteforce implementation for finding shortest path in any graph. Specially this implementation should
 * handle negative cycles in graphs well.
 * </p>
 * 
 * @author LuVar
 * @param <V>
 * @param <E>
 * 
 */
public class MyGreedyShortestPath<V, E> implements MyShortestPath<V, E> {
	private static final Logger log = Logger.getLogger(MyGreedyShortestPath.class);

	protected final Transformer<E, ? extends Number> transformer;
	private final Graph<V, E> graph;
	/**
	 * Path search limit in miliseconds...
	 */
	private long timeLimit = 6700;

	public MyGreedyShortestPath(Graph<V, E> graph, Transformer<E, ? extends Number> transformer) {
		this.graph = graph;
		this.transformer = transformer;
	}

	public long getTimeLimit() {
		return this.timeLimit;
	}

	/**
	 * <p>
	 * Timelimit in miliseconds for searching for path.
	 * </p>
	 * 
	 * @param timeLimit
	 */
	public void setTimeLimit(long timeLimit) {
		this.timeLimit = timeLimit;
	}

	@Override
	public List<E> getPath(V source, V target) {
		if (!this.graph.containsVertex(source)) {
			throw new IllegalArgumentException("Specified source vertex " + source + " is not part of graph " + this.graph);
		}

		if (!this.graph.containsVertex(target)) {
			throw new IllegalArgumentException("Specified target vertex " + target + " is not part of graph " + this.graph);
		}

		long startTime = System.currentTimeMillis();
		DijkstraShortestPath<V, E> dsp = new DijkstraShortestPath<V, E>(this.graph);
		Number minimalHopN = dsp.getDistance(source, target);
		if (minimalHopN == null) {
			throw new RuntimeException("Path not reachable! Path from " + source + ", to " + target);
		}
		int minimalHop = minimalHopN.intValue();

		ArrayList<ContextOfOneCrawler<V, E>> possiblePaths = new ArrayList<ContextOfOneCrawler<V, E>>();
		Set<ContextOfOneCrawler<V, E>> set = new HashSet<ContextOfOneCrawler<V, E>>();
		ContextOfOneCrawler<V, E> a = new ContextOfOneCrawler<V, E>(source);
		set.add(a);

		int actualTreshold = minimalHop * 2;
		long time = 0;

		int i = 0;
		while (/* (set.size() == 0) && */(possiblePaths.size() < 3) && time < this.timeLimit) {
			i++;
			actualTreshold--;
			if ((i % 4) == 0) {
				time = System.currentTimeMillis() - startTime;
				log.debug("Time spent " + time + " ms. Actualy having " + set.size() + " contexts.");
			}
			ArrayList<ContextOfOneCrawler<V, E>> copy = new ArrayList<ContextOfOneCrawler<V, E>>(set);
			set.clear();
			for (ContextOfOneCrawler<V, E> context : copy) {
				Collection<E> outgoing = this.graph.getOutEdges(context.getActualNode());
				for (E e : outgoing) {
					// I dont want to go back along any travelled edge
					if (!context.getVisitedEdges().contains(e)) {
						V newPosition = this.graph.getOpposite(context.getActualNode(), e);
						int thisWouldBe = dsp.getDistance(newPosition, target).intValue();
						if (thisWouldBe > actualTreshold || set.size() > 150) {
							continue;
						}
						if (!context.shouldGoThere(e, newPosition)) {
							continue;
						}
						ContextOfOneCrawler<V, E> newCont = context.getNewFork(e, newPosition, this.transformer.transform(e).doubleValue());
						if (newCont.getActualNode().equals(target)) {
							long newPossiblePathTime = System.currentTimeMillis();
							log.debug("New possible path found after " + (newPossiblePathTime - startTime) + " ms from start.");
							possiblePaths.add(newCont);
						} else {
							set.add(newCont);
						}
					}
				}// end of foreach e in outgoing
			}// end of foreach contextOfOneCrawler in set copy
			if (set.size() == 0 && possiblePaths.size() == 0) {
				// throw new RuntimeException("Sorry, path not constructed. Try again.");
				return new LinkedList<E>();
			}
		}// end of main for loop

		if (possiblePaths.size() == 0) {
			return new LinkedList<E>();
		}

		ContextOfOneCrawler<V, E> best = Collections.min(possiblePaths, this.getComparator());

		long endTime = System.currentTimeMillis();
		log.debug("Path found after " + (endTime - startTime) + " ms.");

		LinkedList<E> path = new LinkedList<E>();
		path = best.getVisitedEdges();
		return path;
	}

	private Comparator<ContextOfOneCrawler<V, E>> getComparator() {
		Comparator<ContextOfOneCrawler<V, E>> navrat;
		navrat = new Comparator<ContextOfOneCrawler<V, E>>() {
			@Override
			public int compare(ContextOfOneCrawler<V, E> o1, ContextOfOneCrawler<V, E> o2) {
				return Double.compare(o1.getDistanceTravlled(), o2.getDistanceTravlled());
			}
		};
		return navrat;
	}// end of private comparator
}
