package sk.stuba.fiit.pogamut.jungigation.worldInfo.prophets;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.AbstractMap.SimpleImmutableEntry;
import java.util.Map.Entry;

import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.objectsCache.ItemsCache;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.objectsCache.SimpleItemInfo;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.snapshoot.ItemSnapshoot;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.snapshoot.Snapshoot;

/**
 * <p>
 * Class responsible for prediction of items, mainly when they will spawn and with what probability
 * it is spawned and not taken. Probability of taking items is extracted partly from
 * {@link GamersProphet} instance, which is given in constructor. 
 * </p>
 * <p>
 * TODO probably some predicting of future state can be useful.
 * </p>
 * 
 * @author LuVar
 *
 */
public class ItemsProphet extends ItemsCache {
	/**
	 * <p>
	 * 
	 * </p>
	 * 
	 * @param worldView
	 * @param playersProphet
	 */
	public ItemsProphet(IWorldView worldView, GamersProphet playersProphet) {
		super(worldView);
	}

	@Override
	protected void notify(Item event) {
		super.notify(event);
		//TODO zmenit i odhad a updatovat itemy, ak budu updatovatelne instancie, ako flajky napriklad...
	}
	
	/**
	 * <p>
	 * Tries to estimate if item is spawned, or no.
	 * </p>
	 *  
	 * @param itemId
	 * @return
	 */
	public SimpleItemInfo getItemPrediction(UnrealId itemId) {
		List<ItemSnapshoot> history = this.getItemHistory(itemId);
		double ageSum = 0;
		for (Snapshoot snapshootsOfItem : history) {
			ageSum += snapshootsOfItem.getAge();
		}
		Set<Entry<Location, Double>> location = new HashSet<Entry<Location,Double>>(history.size());
		for (Snapshoot snapshootsOfItem : history) {
			//TODO do some magic
			location.add(new SimpleImmutableEntry<Location, Double>(snapshootsOfItem.getLocation(), snapshootsOfItem.getAge() / ageSum));
		}
		SimpleItemInfo navrat = new SimpleItemInfo(itemId, location);
		return navrat;
	}
}
