/**
 * 
 */
package sk.stuba.fiit.pogamut.jungigation.worldInfo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import sk.stuba.fiit.pogamut.jungigation.worldInfo.score.TeamScoreChanged;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.TeamScore;

/**
 * @author LuVar
 * 
 */
public class TeamScoreTable implements IWorldObjectEventListener<TeamScore, WorldObjectUpdatedEvent<TeamScore>> {
	private final List<TeamScoreChanged> listeners = Collections.synchronizedList(new ArrayList<TeamScoreChanged>());
	
	private int redScore = -1;
	private int blueScore = -1;
	
	/**
	 * Constructor. Registers itself on the given WorldView object.
	 * 
	 * @param worldView WorldView object to register to.
	 */
	public TeamScoreTable(IWorldView worldView) {
		worldView.addEventListener(TeamScore.class, this);
	}
	
	public void addTeamScoreChangedListener(TeamScoreChanged list) {
		this.listeners.add(list);
	}
	
	public void removeTeamScoreChangedListener(TeamScoreChanged list) {
		this.listeners.remove(list);
	}
	
	@Override
	public void notify(WorldObjectUpdatedEvent<TeamScore> event) {
		TeamScore ts = event.getObject();
		int team = ts.getTeam();
		switch (team) {
		case AgentInfo.TEAM_BLUE:
			this.setBlueScore(ts.getScore());
			break;
		case AgentInfo.TEAM_RED:
			this.setRedScore(ts.getScore());
			break;
		default:
			break;
		}
	}
	
	private void setBlueScore(int newScore) {
		if (this.blueScore == newScore) {
			return;
		}
		int oldScore = this.blueScore;
		this.blueScore = newScore;
		TeamScoreChanged listenersArray[];
		synchronized (this.listeners) {
			listenersArray = new TeamScoreChanged[this.listeners.size()];
			listenersArray = this.listeners.toArray(listenersArray);
		}
		for (TeamScoreChanged tsc : listenersArray) {
			tsc.blueScored();
			tsc.teamScoreChanged(this.redScore, this.blueScore);
		}// end of foreach tsc in listenersArray
	}// end of method setBlueScore
	
	private void setRedScore(int newScore) {
		if (this.redScore == newScore) {
			return;
		}
		int oldScore = this.redScore;
		this.redScore = newScore;
		TeamScoreChanged listenersArray[];
		synchronized (this.listeners) {
			listenersArray = new TeamScoreChanged[this.listeners.size()];
			listenersArray = this.listeners.toArray(listenersArray);
		}
		for (TeamScoreChanged tsc : listenersArray) {
			tsc.redScored();
			tsc.teamScoreChanged(this.redScore, this.blueScore);
		}// end of foreach tsc in listenersArray
	}// end of method setRedScore
}
