package sk.stuba.fiit.pogamut.jungigation.pathPlanners;

import java.util.Collection;

import sk.stuba.fiit.pogamut.jungigation.objects.MyEdge;
import sk.stuba.fiit.pogamut.jungigation.objects.MyVertice;
import sk.stuba.fiit.pogamut.jungigation.transformers.EdgeToDataCountNumberTransformer;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import edu.uci.ics.jung.graph.Graph;

/**
 * <p>
 * Path planner for explorers of map. It use class {@link EdgeToDataCountNumberTransformer} for computing path to
 * target. Planner tends to plan path thru not tested edges, or edges with less data available. If edge has in its time
 * to travel array more than 3 runs with value more than 100, it will try to keep not going thru this edges.
 * </p>
 * 
 * @author LuVar
 * 
 * @see EdgeToDataCountNumberTransformer
 */
public class PathPlannerForDataAcquisition extends SimplestDijkstraPathPlanner {
    public PathPlannerForDataAcquisition(Graph<MyVertice, MyEdge> g, UT2004Bot bot, Collection<NavPoint> navpoints) {
	super(g, bot, navpoints, new EdgeToDataCountNumberTransformer());
    }
}
