/*
 * Decompiled with CFR 0.152.
 */
package jung.myio;

import edu.uci.ics.jung.io.graphml.GraphMetadata;
import org.apache.commons.collections15.Transformer;
import sk.stuba.fiit.pogamut.jungigation.objects.NavigationGraphSynchronized;

public class MetadataGraphTransformer
implements Transformer<NavigationGraphSynchronized, GraphMetadata> {
    public GraphMetadata transform(NavigationGraphSynchronized graph) {
        GraphMetadata gm = new GraphMetadata();
        switch (graph.getDefaultEdgeType()) {
            case DIRECTED: {
                gm.setEdgeDefault(GraphMetadata.EdgeDefault.DIRECTED);
                break;
            }
            case UNDIRECTED: {
                gm.setEdgeDefault(GraphMetadata.EdgeDefault.UNDIRECTED);
                break;
            }
            default: {
                throw new RuntimeException("Graph method getDefaultEdgeType() returned unknown value! Value=" + graph.getDefaultEdgeType() + ".");
            }
        }
        gm.setGraph((Object)graph);
        gm.setProperty("LearningTime", Double.toString(graph.getLearningTime()));
        gm.setProperty("StucksCount", Long.toString(graph.getStucksCount()));
        gm.setProperty("RespawnCount", Long.toString(graph.getRespawnCount()));
        return gm;
    }
}

