package sk.stuba.fiit.pogamut.jungigation.worldInfo.snapshoot;

import sk.stuba.fiit.pogamut.jungigation.worldInfo.GameTime;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.objectsCache.misc.LocationValhalla;
import cz.cuni.amis.pogamut.base3d.worldview.object.Velocity;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;

public class PlayerSnapshot extends Snapshoot {
    protected final Velocity velocity;
    protected final String weapon;
    protected final int firing;

    public PlayerSnapshot(Player player) {
	super(player.getId(), player.getLocation(), player.getSimTime());
	this.velocity = player.getVelocity();
	this.weapon = player.getWeapon();
	this.firing = player.getFiring();
    }

    public PlayerSnapshot(PlayerSnapshot playerSnapshot) {
	super(playerSnapshot);
	this.velocity = playerSnapshot.getVelocity();
	this.weapon = playerSnapshot.getWeapon();
	this.firing = playerSnapshot.getFiring();
    }

    protected PlayerSnapshot(Self self) {
	super(self.getId(), self.getLocation(), self.getSimTime());
	this.velocity = self.getVelocity();
	// TODO tu ukladam daco ine, ako by som mal!!!
	this.weapon = self.getWeapon();
	// this.firing = self.getFiring();
	if (self.isShooting()) {
	    this.firing = 1;
	} else {
	    if (self.isAltFiring()) {
		this.firing = 2;
	    } else {
		this.firing = 0;
	    }
	}
    }// end of constructor with Self parameter

    public PlayerSnapshot(PlayerKilled killEvent) {
	// TODO: ak bude chodit kill time, tak ho tu pouzit
	super(killEvent.getId(), new LocationValhalla(), GameTime.actualTime);
	this.velocity = null;
	this.weapon = null;
	this.firing = 0;
    }

    /**
     * 
     * @return
     * 
     * @see Player#getVelocity()
     */
    public Velocity getVelocity() {
	return this.velocity;
    }

    /**
     * 
     * @return
     * 
     * @see Player#getWeapon()
     */
    public String getWeapon() {
	return this.weapon;
    }

    /**
     * 
     * @return
     * 
     * @see Player#getFiring()
     */
    public int getFiring() {
	return this.firing;
    }
}
