/*
 * WorldProphetPanel.java
 *
 * Created on 4.3.2010, 21:26:14
 */

package sk.stuba.fiit.pogamut.jungigation.worldInfo.prophets;

import java.awt.Color;
import java.awt.Graphics;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Map.Entry;

import sk.stuba.fiit.pogamut.jungigation.worldInfo.objects.NotifiableMap;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.objects.SimpleFlagInfo;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.objects.SimpleGamerInfo;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.objects.UpdateAndDeleteListener;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.objects.UpdateListener;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.snapshoot.GamerSnapshot;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.map.Box;

/**
 * 
 * @author LuVar
 */
public class WorldProphetPanel extends javax.swing.JPanel implements UpdateAndDeleteListener<SimpleGamerInfo> {
    private WorldProphet worldProphet;

    /** Creates new form WorldProphetPanel */
    public WorldProphetPanel() {
	initComponents();
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

	setBorder(javax.swing.BorderFactory.createEtchedBorder());
	addComponentListener(new java.awt.event.ComponentAdapter() {
	    @Override
	    public void componentResized(java.awt.event.ComponentEvent evt) {
		formComponentResized(evt);
	    }
	});

	javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
	this.setLayout(layout);
	layout.setHorizontalGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGap(0, 396, Short.MAX_VALUE));
	layout.setVerticalGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGap(0, 296, Short.MAX_VALUE));
    }// </editor-fold>//GEN-END:initComponents

    private void formComponentResized(java.awt.event.ComponentEvent evt) {// GEN-FIRST:event_formComponentResized
	this.recalculateScales();
    }// GEN-LAST:event_formComponentResized

    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables

    private void paintPlayer(Graphics g, Entry<UnrealId, List<GamerSnapshot>> gamer) {
	g.setColor(Color.LIGHT_GRAY);
	List<GamerSnapshot> loc = gamer.getValue();
	for (GamerSnapshot gamerHist : loc) {
	    double origX = gamerHist.getLocation().x;
	    double origY = gamerHist.getLocation().y;
	    double x = Math.round(this.xScale * (origX + this.xOffset));
	    double y = Math.round(this.yScale * (origY + this.yOffset));
	    g.fillOval((int) x - 1, (int) y - 1, 3, 3);
	    double age = gamerHist.getAge();
	    age = Math.round(age * 10.0) / 10.0;
	    // TODO farba podla age
	    // g.drawString("age" + age, (int)x , (int)y);
	}// end of for each entry in loc
    }

    private void paintPlayer(Graphics g, SimpleGamerInfo simplePlayerInfo) {
	Set<Entry<Location, Double>> loc = simplePlayerInfo.getFuzzyLocation();
	for (Entry<Location, Double> entry : loc) {
	    double origX = entry.getKey().x;
	    double origY = entry.getKey().y;
	    double x = Math.round(this.xScale * (origX + this.xOffset));
	    double y = Math.round(this.yScale * (origY + this.yOffset));
	    if (simplePlayerInfo.isEnemy()) {
		g.setColor(Color.red);
	    } else {
		g.setColor(Color.blue);
	    }
	    g.fillOval((int) x - 2, (int) y - 2, 5, 5);
	    g.setColor(Color.BLACK);
	    g.drawString("" + entry.getValue(), (int) x, (int) y);
	}// end of for each entry in loc
    }

    @Override
    public void paint(Graphics g) {
	super.paint(g);
	try {
	    if (this.isPaintPlayersHistory()) {
		// Spravim si kopiu, aby sa mi nemodifikovala pri vykreslovani...
		Map<UnrealId, List<GamerSnapshot>> hist = new HashMap<UnrealId, List<GamerSnapshot>>(this.worldProphet.getGamersProphet().getGamersHistory());
		for (Entry<UnrealId, List<GamerSnapshot>> gamer : hist.entrySet()) {
		    paintPlayer(g, gamer);
		}
	    }
	    if (this.players != null && this.isPaintPlayers()) {
		this.worldProphet.getGamersProphet().reestimateAllPlayers();
		Collection<SimpleGamerInfo> pl = this.players.getMap().values();
		for (SimpleGamerInfo simplePlayerInfo : pl) {
		    paintPlayer(g, simplePlayerInfo);
		}// end of for each simplePlayerInfo in pl
	    }// end of if rhis.players != null

	    if (this.myFlag != null && this.enemyFlag != null && this.isPaintFlags()) {
		double origX = this.myFlag.getMostProbableLocation().getKey().x;
		double origY = this.myFlag.getMostProbableLocation().getKey().y;
		double x = Math.round(this.xScale * (origX + this.xOffset));
		double y = Math.round(this.yScale * (origY + this.yOffset));
		g.setColor(Color.blue);
		// System.out.println("-------------------x=" + x + ",y=" + y);
		g.drawOval((int) x - 1, (int) y - 1, 3, 3);
		g.setColor(Color.BLACK);
		g.drawString("My " + this.myFlag.getMostProbableLocation().getValue(), (int) x, (int) y);

		x = Math.round(this.xScale * (this.enemyFlag.getMostProbableLocation().getKey().x + this.xOffset));
		y = Math.round(this.yScale * (this.enemyFlag.getMostProbableLocation().getKey().y + this.yOffset));
		g.setColor(Color.red);
		g.drawOval((int) x - 1, (int) y - 1, 3, 3);
		g.setColor(Color.BLACK);
		g.drawString("Enemy " + this.enemyFlag.getMostProbableLocation().getValue(), (int) x, (int) y);
	    }
	} catch (Exception ex) {
	    System.err.println("Error while painting. Error: " + ex.getMessage() + ". Stack:");
	    ex.printStackTrace();
	}
    }

    public void setWorldProphet(WorldProphet worldProphet) {
	this.unregisterProphet();
	this.worldProphet = worldProphet;
	this.registerProphet();
    }

    SimpleFlagInfo enemyFlag = null;
    SimpleFlagInfo myFlag = null;

    NotifiableMap<SimpleGamerInfo> players = null;

    private double xScale = 1;
    private double xOffset = 0;
    private double yScale = 1;
    private double yOffset = 0;

    private void unregisterProphet() {
	if (this.worldProphet == null) {
	    return;
	}
    }

    private void registerProphet() {
	this.recalculateScales();
	enemyFlag = this.worldProphet.getFlagsProphet().getEnemySimpleFlag();
	enemyFlag.addChangeListener(new UpdateListener<SimpleFlagInfo>() {
	    @Override
	    public void notifyOfChange(SimpleFlagInfo updatedInstance) {
		// WorldProphetPanel.this.revalidate();
		WorldProphetPanel.this.repaint();
	    }
	});
	myFlag = this.worldProphet.getFlagsProphet().getMySimpleFlag();
	myFlag.addChangeListener(new UpdateListener<SimpleFlagInfo>() {
	    @Override
	    public void notifyOfChange(SimpleFlagInfo updatedInstance) {
		// WorldProphetPanel.this.revalidate();
		WorldProphetPanel.this.repaint();
	    }
	});
	this.players = this.worldProphet.getGamersProphet().getGamers();
	this.players.addChangeListener(this);
    }

    @Override
    public void notifyOfChange(SimpleGamerInfo updatedInstance) {
	WorldProphetPanel.this.repaint();
    }

    @Override
    public void notifyOfDelete(SimpleGamerInfo deletedInstance) {
	WorldProphetPanel.this.repaint();
    }

    private void recalculateScales() {
	Box mapBox = this.worldProphet.getMapBox();
	int width = this.getWidth();
	int height = this.getHeight();
	this.xScale = width / (mapBox.getDeltaX() * 1.15);
	this.yScale = height / (mapBox.getDeltaY() * 1.15);
	this.xOffset = -mapBox.minX + (mapBox.getDeltaX() * 0.075);
	this.yOffset = -mapBox.minY + (mapBox.getDeltaY() * 0.075);
	this.repaint();
    }

    private boolean paintPlayers = true;
    private boolean paintFlags = true;
    private boolean paintPlayersHistory = false;

    public boolean isPaintPlayers() {
	return paintPlayers;
    }

    public void setPaintPlayers(boolean paintPlayers) {
	this.paintPlayers = paintPlayers;
    }

    public boolean isPaintFlags() {
	return paintFlags;
    }

    public void setPaintFlags(boolean paintFlags) {
	this.paintFlags = paintFlags;
    }

    public boolean isPaintPlayersHistory() {
	return paintPlayersHistory;
    }

    public void setPaintPlayersHistory(boolean paintPlayersHistory) {
	this.paintPlayersHistory = paintPlayersHistory;
    }
}
