package sk.stuba.fiit.pogamut.jungigation.worldInfo.objectsCache;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import sk.stuba.fiit.pogamut.jungigation.worldInfo.AdvancedSharedItems;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.SharedItems;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.snapshoot.PlayerSnapshot;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectListener;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AdvancedItems;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Items;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerKilled;

public class PlayersCache extends AbstractNotifiableCache<Player> {
	private final Map<IWorldView, PlayersListener> listeners = new HashMap<IWorldView, PlayersListener>();
	private final Map<IWorldView, PlayerKilledListener> listenersKill = new HashMap<IWorldView, PlayerKilledListener>();
	private final Map<UnrealId, List<PlayerSnapshot>> playersHistory = Collections.synchronizedMap(new HashMap<UnrealId, List<PlayerSnapshot>>());
	
	public static final int HISTORYSIZE = 20;
	
	/**
	 * <p>
	 * For similar functionality look in see section.
	 * </p>
	 * <p>
	 * TODO look also for player left and team changed events...
	 * </p>
	 * 
	 * @param worldView
	 * 
	 * @see FlagsCache
	 * @see ItemsCache
	 * @see SharedItems
	 * @see AdvancedSharedItems
	 * @see Items
	 * @see AdvancedItems
	 */
	public PlayersCache(IWorldView worldView) {
		this.addAnotherViewer(worldView);
	}
	
	/**
	 * @see sk.stuba.fiit.LuVar.pogamut.jungigation.worldInfo.objectsCache.CacheInterface#addAnotherViewer(cz.cuni.amis.pogamut.base.communication.worldview.IWorldView)
	 */
	@Override
	public void addAnotherViewer(IWorldView worldView) {
		PlayersListener tmp = new PlayersListener();
		this.listeners.put(worldView, tmp);
		worldView.addObjectListener(Player.class, tmp);
		
		PlayerKilledListener tmp2 = new PlayerKilledListener();
		this.listenersKill.put(worldView, tmp2);
		worldView.addEventListener(PlayerKilled.class, tmp2);
	}
	
	/**
	 * @see sk.stuba.fiit.LuVar.pogamut.jungigation.worldInfo.objectsCache.CacheInterface#removeViewer(cz.cuni.amis.pogamut.base.communication.worldview.IWorldView)
	 */
	@Override
	public void removeViewer(IWorldView worldView) {
		PlayersListener tmp = this.listeners.get(worldView);
		this.listeners.remove(worldView);
		worldView.removeObjectListener(Player.class, tmp);
		
		PlayerKilledListener tmp2 = this.listenersKill.get(worldView);
		this.listenersKill.remove(worldView);
		worldView.removeEventListener(PlayerKilled.class, tmp2);
	}
	
	/**
	 * <p>
	 * Returns list of last known states for desired item. Returned list is unmodifiable.
	 * </p>
	 * 
	 * @param id
	 * @return
	 */
	public List<PlayerSnapshot> getPlayerHistory(UnrealId id) {
		if (id == null) {
			// throw new IllegalArgumentException();
			throw new NullPointerException("id parameter could not be null!");
		}
		return Collections.unmodifiableList(this.playersHistory.get(id));
	}
	
	public Map<UnrealId, List<PlayerSnapshot>> getPlayersHistory() {
		return Collections.unmodifiableMap(this.playersHistory);
	}
	
	public int getNumberOfPlayers() {
		return this.playersHistory.size();
	}
	
	@Override
	protected void notify(Player event) {
		List<PlayerSnapshot> oneItemHistory = this.playersHistory.get(event.getId());
		if (oneItemHistory == null) {
			// TODO choose best implementation of list or code own, synchronized
			oneItemHistory = Collections.synchronizedList(new LinkedList<PlayerSnapshot>());
			this.playersHistory.put(event.getId(), oneItemHistory);
		}// end of if itemHistory == null
		oneItemHistory.add(0, new PlayerSnapshot(event));
		// keep just last 20 item states
		while (oneItemHistory.size() > PlayersCache.HISTORYSIZE) {
			oneItemHistory.remove(PlayersCache.HISTORYSIZE);
		}
		super.notify(event);
	}
	
	protected void notifyKill(PlayerKilled event) {
		// TODO notify supperclass about historry change...
		List<PlayerSnapshot> oneItemHistory = this.playersHistory.get(event.getId());
		if (oneItemHistory == null) {
			// TODO choose best implementation of list or code own, synchronized
			oneItemHistory = Collections.synchronizedList(new LinkedList<PlayerSnapshot>());
			this.playersHistory.put(event.getId(), oneItemHistory);
		}// end of if itemHistory == null
		oneItemHistory.add(0, new PlayerSnapshot(event));
		// keep just last 20 item states
		while (oneItemHistory.size() > PlayersCache.HISTORYSIZE) {
			oneItemHistory.remove(PlayersCache.HISTORYSIZE);
		}
	}
	
	private class PlayersListener implements IWorldObjectListener<Player> {
		@Override
		public void notify(IWorldObjectEvent<Player> event) {
			PlayersCache.this.notify(event.getObject());
		}// end of method notify
	}// end of private class ItemsCache
	
	private class PlayerKilledListener implements IWorldEventListener<PlayerKilled> {
		@Override
		public void notify(PlayerKilled event) {
			PlayersCache.this.notifyKill(event);
		}// end of method notify
	}// end of private class
}
