/**
 * 
 */
package sk.stuba.fiit.pogamut.jungigation.worldInfo.objects;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;

/**
 * @author LuVar
 *
 */
public class NotifiableMap<CONCRETECONTAINEDCLASS extends ProphetObjectVision<CONCRETECONTAINEDCLASS>> implements UpdateAndDeleteListener<CONCRETECONTAINEDCLASS> {
	private List<UpdateAndDeleteListener<CONCRETECONTAINEDCLASS>> listeners = Collections.synchronizedList(new ArrayList<UpdateAndDeleteListener<CONCRETECONTAINEDCLASS>>());
	
	private Map<UnrealId, CONCRETECONTAINEDCLASS> mapData = Collections.synchronizedMap(new HashMap<UnrealId, CONCRETECONTAINEDCLASS>());
	
	public void addChangeListener(UpdateAndDeleteListener<CONCRETECONTAINEDCLASS> listener) {
		this.listeners.add(listener);
	}

	public void removeChangeListener(UpdateAndDeleteListener<CONCRETECONTAINEDCLASS> listener) {
		this.listeners.remove(listener);
	}
	
	protected void notifyOfChangeAllListeners(CONCRETECONTAINEDCLASS changedOrAddedObject) {
		for (UpdateListener<CONCRETECONTAINEDCLASS> listener : this.listeners.toArray(new UpdateListener[this.listeners.size()])) {
			try {
				listener.notifyOfChange(changedOrAddedObject);
			} catch (Exception ex) {
				System.err.println("Problem while notifiing some of listener! Continuing. Error:" + ex);
			}
		}// end of foreach
	}// end of method notifyOfChangeAllListeners

	protected void notifyOfDeleteAllListeners(CONCRETECONTAINEDCLASS deletedInstance) {
		for (UpdateListener<CONCRETECONTAINEDCLASS> listener : this.listeners.toArray(new UpdateListener[this.listeners.size()])) {
			try {
				listener.notifyOfChange(deletedInstance);
			} catch (Exception ex) {
				System.err.println("Problem while notifiing some of listener! Continuing. Error:" + ex);
			}
		}// end of foreach
	}// end of method notifyOfChangeAllListeners
	
	@Override
	public void notifyOfChange(CONCRETECONTAINEDCLASS changedOrAddedObject) {
		this.notifyOfChangeAllListeners(changedOrAddedObject);
	}

	@Override
	public void notifyOfDelete(CONCRETECONTAINEDCLASS deletedInstance) {
		this.notifyOfDeleteAllListeners(deletedInstance);
	}
	
	/**
	 * <p>
	 * Adds given object to internal map, registers to its change events and finally
	 * notifies registered listeners about map change.
	 * </p>
	 * 
	 * @param id
	 * @param object
	 */
	public void addObject(UnrealId id, CONCRETECONTAINEDCLASS object) {
		this.mapData.put(id, object);
		object.addChangeListener(this);
		this.notifyOfChange(object);
	}
	
	/**
	 * 
	 * @param id
	 * @param object
	 * 
	 * @see	#addObject(UnrealId, ProphetObjectVision)
	 */
	public void removeObject(UnrealId id, CONCRETECONTAINEDCLASS object) {
		this.mapData.remove(id);
		object.removeChangeListener(this);
		this.notifyOfDelete(object);
	}
	
	/**
	 * <p>
	 * Read only map. Adding is allowed only for mantainer class!
	 * </p>
	 * 
	 * @return
	 */
	public Map<UnrealId, CONCRETECONTAINEDCLASS> getMap() {
		//return Collections.unmodifiableMap(this.mapData);
		return this.mapData;
	}
}
