package sk.stuba.fiit.pogamut.jungigation.transformers;

import java.awt.Color;
import java.awt.Paint;

import org.apache.commons.collections15.Transformer;

import sk.stuba.fiit.pogamut.jungigation.objects.MyVertice;
import edu.uci.ics.jung.visualization.BasicVisualizationServer;

/**
 *
 * @author LuVar
 */
public class VertexToPaintTransformer implements Transformer<MyVertice, Paint>{
	private final BasicVisualizationServer<MyVertice, Object> bvs;
	public VertexToPaintTransformer(BasicVisualizationServer<MyVertice, Object> bvs) {
		this.bvs = bvs;
	}

	public Paint transform(MyVertice i) {
		if(this.bvs != null && this.bvs.getPickedVertexState().isPicked(i)) {
			return Color.yellow;
		}
		Paint navrat = Color.red;
		if(i.getItemAmount() > 0) {
			navrat = Color.green;
		}
		if(i.getItemType() != null && i.getItemType().toLowerCase().contains("health")) {
			navrat = Color.blue;
		}
		return navrat;
	}
}
