package sk.stuba.fiit.pogamut.jungigation.transformers;

import java.awt.Color;
import java.awt.Paint;

import org.apache.commons.collections15.Transformer;
import sk.stuba.fiit.pogamut.jungigation.objects.MyEdge;

/**
 *
 * @author LuVar
 */
public class EdgeToPaintTransformer implements Transformer<MyEdge, Paint> {
    public int max = 20;
    public int offset = 5;

    public Paint transform(MyEdge i) {
    	if(i.getTravelTime() > 100.0) {
    		return Color.red;
    	}
        float color = (float)(i.getNumberOfTravelsInArray() + offset) / (float)this.max;
        color = (color > 1f)?1f:color;
        return new Color(1f - color, color, 1f - color);
    }
}
