package sk.stuba.fiit.pogamut.jungigation.tests;

import java.io.IOException;
import java.util.List;

import jung.myalghoritm.FloydWarshallShortestPath;
import jung.myalghoritm.MyShortestPath;
import sk.stuba.fiit.pogamut.jungigation.objects.MyEdge;
import sk.stuba.fiit.pogamut.jungigation.transformers.EdgeToTimeNumberTransformer;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.DirectedSparseGraph;

/**
 * 
 * @author LuVar
 */
public class JUNGDijkstraTest {
    public static void main(String args[]) {
	// DirectedGraph<String, MyEdge> g = getGraph();
	DirectedGraph<String, MyEdge> g = getGraphWithNegativeCycle();

	// MyShortestPath<String, MyEdge> dsp = new MyDijkstraShortestPath<String, MyEdge>(g, new
	// EdgeToDataCountNumberTransformer(), false);
	// MyShortestPath<String, MyEdge> dsp = new FloydWarshallShortestPath<String, MyEdge>(g, new
	// EdgeToDataCountNumberTransformer(), false);
	MyShortestPath<String, MyEdge> dsp = new FloydWarshallShortestPath<String, MyEdge>(g, new EdgeToTimeNumberTransformer(), false);

	List<MyEdge> path = dsp.getPath("A", "D");
	for (MyEdge myEdge : path) {
	    System.out.println(myEdge);
	}

	System.out.println("End of useless test. This file is meant to be an library. Use its public class and functions instead of running it!");
	try {
	    System.in.read();
	} catch (IOException ex) {
	}
    }

    public static DirectedGraph<String, MyEdge> getGraph() {
	DirectedGraph<String, MyEdge> g = new DirectedSparseGraph<String, MyEdge>();
	g.addVertex("A");
	g.addVertex("B");
	g.addVertex("C");
	g.addVertex("D");
	g.addEdge(new MyEdge(1, 10), "A", "B");
	g.addEdge(new MyEdge(2, 15), "B", "C");
	g.addEdge(new MyEdge(3, 1), "C", "A");
	g.addEdge(new MyEdge(4, 27), "A", "C");
	return g;
    }

    public static DirectedGraph<String, MyEdge> getGraphWithNegativeCycle() {
	DirectedGraph<String, MyEdge> g = new DirectedSparseGraph<String, MyEdge>();
	g.addVertex("A");
	g.addVertex("B");
	g.addVertex("C");
	g.addVertex("D");
	g.addVertex("E");
	g.addEdge(new MyEdge(1, 10), "A", "B");
	g.addEdge(new MyEdge(2, 15), "B", "C");
	g.addEdge(new MyEdge(3, 1), "C", "A");
	g.addEdge(new MyEdge(-10, 27), "A", "C");
	g.addEdge(new MyEdge(4, 27), "B", "D");
	return g;
    }
}
