package jung.myio;

import org.apache.commons.collections15.Transformer;

import sk.stuba.fiit.pogamut.jungigation.objects.MyVertice;
import edu.uci.ics.jung.io.graphml.NodeMetadata;

/**
 * <p>
 * Transforms {@link MyVertice} instances to {@link NodeMetadata} instances, which is than serialized to graphML files
 * by {@link GraphMLWriter2}.
 * </p>
 * 
 * @author LuVar
 * 
 */
public class MetadataNodeTransformer implements Transformer<MyVertice, NodeMetadata> {

    @Override
    public NodeMetadata transform(MyVertice v) {
	NodeMetadata navrat = new NodeMetadata();
	navrat.setId(v.getId().getStringId());
	navrat.setProperty("x", Double.toString(v.getLocation().getX()));
	navrat.setProperty("y", Double.toString(v.getLocation().getY()));
	navrat.setProperty("z", Double.toString(v.getLocation().getZ()));

	if (v.getItemType() != null) {
	    navrat.setProperty("ItemType", v.getItemType());
	}
	if (v.getItemAmount() >= 0) {
	    navrat.setProperty("ItemAmount", Integer.toString(v.getItemAmount()));
	}
	if (v.getSpawnFor() != -1) {
	    navrat.setProperty("SpawnFor", Integer.toString(v.getSpawnFor()));
	}
	return navrat;
    }

}
