package jung.myio;

import org.apache.commons.collections15.Transformer;

import sk.stuba.fiit.pogamut.jungigation.objects.NavigationGraphSynchronized;
import edu.uci.ics.jung.io.graphml.GraphMetadata;
import edu.uci.ics.jung.io.graphml.GraphMetadata.EdgeDefault;

public class MetadataGraphTransformer implements Transformer<NavigationGraphSynchronized, GraphMetadata> {

    @Override
    public GraphMetadata transform(NavigationGraphSynchronized graph) {
	GraphMetadata gm = new GraphMetadata();
	switch (graph.getDefaultEdgeType()) {
	case DIRECTED:
	    gm.setEdgeDefault(EdgeDefault.DIRECTED);
	    break;
	case UNDIRECTED:
	    gm.setEdgeDefault(EdgeDefault.UNDIRECTED);
	    break;
	default:
	    throw new RuntimeException("Graph method getDefaultEdgeType() returned unknown value! Value=" + graph.getDefaultEdgeType() + ".");
	}
	gm.setGraph(graph);

	gm.setProperty(NavigationGraphSynchronized.PROPERTY_LearningTime, Double.toString(graph.getLearningTime()));
	gm.setProperty(NavigationGraphSynchronized.PROPERTY_StucksCount, Long.toString(graph.getStucksCount()));
	gm.setProperty(NavigationGraphSynchronized.PROPERTY_RespawnCount, Long.toString(graph.getRespawnCount()));
	return gm;
    }

}
