package jung.myalghoritm.AStar;

public class VerticeForAStar<V> {
    public final V vertice;
    /**
     * Distance from start along optimal path.
     */
    public double g_score = 0;
    public double h_score = 0;
    /**
     * Estimated total distance from start to goal through y.
     */
    public double f_score = 0;

    public VerticeForAStar(V vertice) {
	this.vertice = vertice;
    }

    @Override
    public boolean equals(Object obj) {
	if (obj instanceof VerticeForAStar<?>) {
	    VerticeForAStar<?> new_name = (VerticeForAStar<?>) obj;
	    return this.vertice.equals(new_name.vertice);
	}// end of instanceof obj is type VerticeForAStar<?>
	return false;
    }

    @Override
    public int hashCode() {
	return this.vertice.hashCode();
    }

    @Override
    public String toString() {
	return "(gs:" + this.g_score + ")" + "(hs:" + this.h_score + ")" + "(fs:" + this.f_score + ")" + this.vertice.toString();
    }
}
