/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.maven3;

import java.util.Arrays;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.LifecycleExecutor;
import org.apache.maven.project.MavenProject;
import org.sonar.api.batch.maven.MavenPlugin;
import org.sonar.api.batch.maven.MavenPluginHandler;
import org.sonar.api.resources.Project;
import org.sonar.api.utils.SonarException;
import org.sonar.api.utils.TimeProfiler;
import org.sonar.batch.MavenPluginExecutor;

public class Maven3PluginExecutor
implements MavenPluginExecutor {
    private LifecycleExecutor lifecycleExecutor;
    private MavenSession mavenSession;

    public Maven3PluginExecutor(LifecycleExecutor le, MavenSession mavenSession) {
        this.lifecycleExecutor = le;
        this.mavenSession = mavenSession;
    }

    public MavenPluginHandler execute(Project project, MavenPluginHandler handler) {
        for (String goal : handler.getGoals()) {
            MavenPlugin plugin = MavenPlugin.getPlugin((MavenProject)project.getPom(), (String)handler.getGroupId(), (String)handler.getArtifactId());
            this.execute(project, Maven3PluginExecutor.getGoal(handler.getGroupId(), handler.getArtifactId(), plugin.getPlugin().getVersion(), goal));
        }
        return handler;
    }

    public void execute(Project project, String goalOrPhase) {
        TimeProfiler profiler = new TimeProfiler().start("Execute " + goalOrPhase);
        try {
            MavenSession projectSession = this.mavenSession.clone();
            projectSession.setCurrentProject(project.getPom());
            projectSession.setProjects(Arrays.asList(project.getPom()));
            projectSession.getRequest().setRecursive(false);
            projectSession.getRequest().setPom(project.getPom().getFile());
            projectSession.getRequest().setGoals(Arrays.asList(goalOrPhase));
            projectSession.getRequest().setInteractiveMode(false);
            this.lifecycleExecutor.execute(projectSession);
        }
        catch (Exception e) {
            throw new SonarException("Unable to execute maven plugin", (Throwable)e);
        }
        finally {
            profiler.stop();
        }
    }

    protected static String getGoal(String groupId, String artifactId, String version, String goal) {
        String defaultVersion = version == null ? "" : version;
        return groupId + ":" + artifactId + ":" + defaultVersion + ":" + goal;
    }
}

