/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.awt.geom.Rectangle2D;
import org.apache.fop.pdf.PDFArray;
import org.apache.fop.pdf.PDFName;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFPages;
import org.apache.fop.pdf.PDFReference;
import org.apache.fop.pdf.PDFResourceContext;
import org.apache.fop.pdf.PDFResources;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.pdf.TransitionDictionary;

public class PDFPage
extends PDFResourceContext {
    protected int pageIndex;

    public PDFPage(PDFResources resources, PDFStream contents, int pageWidth, int pageHeight, int pageIndex) {
        super(resources);
        this.put("Type", new PDFName("Page"));
        this.setContents(contents);
        this.setSimplePageSize(pageWidth, pageHeight);
        this.pageIndex = pageIndex;
    }

    public PDFPage(PDFResources resources, int pageWidth, int pageHeight, int pageIndex) {
        this(resources, null, pageWidth, pageHeight, pageIndex);
    }

    private void setSimplePageSize(int width, int height) {
        Rectangle2D.Double box = new Rectangle2D.Double(0.0, 0.0, width, height);
        this.setMediaBox(box);
        this.setBleedBox(box);
        this.setTrimBox(box);
    }

    private PDFArray toPDFArray(Rectangle2D box) {
        return new PDFArray((PDFObject)this, new double[]{box.getX(), box.getY(), box.getMaxX(), box.getMaxY()});
    }

    public void setMediaBox(Rectangle2D box) {
        this.put("MediaBox", this.toPDFArray(box));
    }

    public void setTrimBox(Rectangle2D box) {
        this.put("TrimBox", this.toPDFArray(box));
    }

    public void setBleedBox(Rectangle2D box) {
        this.put("BleedBox", this.toPDFArray(box));
    }

    public void setContents(PDFStream contents) {
        if (contents != null) {
            this.put("Contents", new PDFReference(contents));
        }
    }

    public void setParent(PDFPages parent) {
        this.put("Parent", new PDFReference(parent));
    }

    public void setTransition(int dur, TransitionDictionary tr) {
        this.put("Dur", new Integer(dur));
        this.put("Trans", tr);
    }

    public int getPageIndex() {
        return this.pageIndex;
    }
}

