/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.starteam.command.status;

import java.io.File;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.status.AbstractStatusCommand;
import org.apache.maven.scm.command.status.StatusScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.starteam.command.StarteamCommand;
import org.apache.maven.scm.provider.starteam.command.StarteamCommandLineUtils;
import org.apache.maven.scm.provider.starteam.command.status.StarteamStatusConsumer;
import org.apache.maven.scm.provider.starteam.repository.StarteamScmProviderRepository;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;

public class StarteamStatusCommand
extends AbstractStatusCommand
implements StarteamCommand {
    protected StatusScmResult executeStatusCommand(ScmProviderRepository repo, ScmFileSet fileSet) throws ScmException {
        this.getLogger().info("Working directory: " + fileSet.getBasedir().getAbsolutePath());
        if (fileSet.getFiles().length != 0) {
            throw new ScmException("This provider doesn't support checking status of a subsets of a directory");
        }
        StarteamScmProviderRepository repository = (StarteamScmProviderRepository)repo;
        StarteamStatusConsumer consumer = new StarteamStatusConsumer(this.getLogger(), fileSet.getBasedir());
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        Commandline cl = StarteamStatusCommand.createCommandLine(repository, fileSet.getBasedir());
        int exitCode = StarteamCommandLineUtils.executeCommandline(cl, consumer, stderr, this.getLogger());
        if (exitCode != 0) {
            return new StatusScmResult(cl.toString(), "The starteam command failed.", stderr.getOutput(), false);
        }
        return new StatusScmResult(cl.toString(), consumer.getChangedFiles());
    }

    public static Commandline createCommandLine(StarteamScmProviderRepository repo, File workingDirectory) {
        Commandline cl = StarteamCommandLineUtils.createStarteamBaseCommandLine("hist", workingDirectory, repo);
        cl.createArgument().setValue("-is");
        return cl;
    }
}

