/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.accurev.commands.checkout;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.checkout.AbstractCheckOutCommand;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.accurev.AccuRevScmProvider;
import org.apache.maven.scm.provider.accurev.AccuRevScmProviderRepository;
import org.apache.maven.scm.provider.accurev.commands.checkout.BaseAccuRevCheckOutCommand;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class AccuRevCheckOutUsingPopCommand
extends AbstractCheckOutCommand
implements BaseAccuRevCheckOutCommand {
    private String accuRevExecutable;

    public AccuRevCheckOutUsingPopCommand(String executable) {
        this.accuRevExecutable = executable;
    }

    public String getMethodName() {
        return "pop";
    }

    protected CheckOutScmResult executeCheckOutCommand(ScmProviderRepository repository, ScmFileSet fileSet, ScmVersion version) throws ScmException {
        try {
            ArrayList checkedFiles;
            int exitCode;
            AccuRevScmProviderRepository accurevRepository = (AccuRevScmProviderRepository)repository;
            final CommandLineUtils.StringStreamConsumer stdout = new CommandLineUtils.StringStreamConsumer();
            Commandline popCommandline = this.createPopStreamCommand(accurevRepository, fileSet, version);
            if (!fileSet.getBasedir().exists()) {
                fileSet.getBasedir().mkdirs();
            }
            if ((exitCode = CommandLineUtils.executeCommandLine((Commandline)popCommandline, (StreamConsumer)new StreamConsumer(checkedFiles = new ArrayList()){
                Pattern pattern = Pattern.compile("Populating element (.*)");
                private final /* synthetic */ ArrayList val$checkedFiles;
                {
                    this.val$checkedFiles = arrayList;
                }

                public void consumeLine(String line) {
                    stdout.consumeLine(line);
                    Matcher m = this.pattern.matcher(line);
                    if (m.matches()) {
                        this.val$checkedFiles.add(m.group(1));
                    }
                }
            }, (StreamConsumer)stdout)) != 0) {
                return new CheckOutScmResult(popCommandline.toString(), "The AccuRev command failed", stdout.getOutput(), false);
            }
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info("Checked out stream \"" + accurevRepository.getStreamName() + "\" contents to folder " + fileSet.getBasedir());
            }
            return new CheckOutScmResult(popCommandline.toString(), checkedFiles);
        }
        catch (CommandLineException e) {
            throw new ScmException("internal error");
        }
    }

    protected Commandline createPopStreamCommand(AccuRevScmProviderRepository repository, ScmFileSet fileSet, ScmVersion version) {
        Commandline commandline = new Commandline();
        commandline.setExecutable(this.accuRevExecutable);
        ArrayList<String> params = new ArrayList<String>();
        params.add("pop");
        AccuRevScmProvider.appendHostToParamsIfNeeded(repository, params);
        commandline.addArguments(params.toArray(new String[params.size()]));
        commandline.addArguments(new String[]{"-v", repository.getStreamName(), "-L", fileSet.getBasedir().getAbsolutePath(), "-R"});
        ArrayList<String> fileSetArguments = new ArrayList<String>();
        String filelistParam = (String)repository.getParams().get("include");
        if (null == filelistParam) {
            fileSetArguments.add(".");
        } else {
            String[] elements = StringUtils.split((String)filelistParam, (String)",");
            fileSetArguments.addAll(Arrays.asList(elements));
        }
        commandline.addArguments(fileSetArguments.toArray(new String[fileSetArguments.size()]));
        return commandline;
    }
}

