/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.jxr.pacman;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import org.apache.maven.jxr.pacman.ClassType;
import org.apache.maven.jxr.pacman.ImportType;
import org.apache.maven.jxr.pacman.JavaFile;
import org.apache.maven.jxr.pacman.PackageType;
import org.codehaus.plexus.util.StringUtils;

public class JavaFileImpl
extends JavaFile {
    private Reader reader;

    public JavaFileImpl(String filename, String encoding) throws IOException {
        this.setFilename(filename);
        this.setEncoding(encoding);
        this.addImportType(new ImportType("java.lang.*"));
        this.parse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse() throws IOException {
        StreamTokenizer stok = null;
        try {
            stok = this.getTokenizer();
            while (stok.nextToken() != -1) {
                if (stok.sval == null) continue;
                if ("package".equals(stok.sval) && stok.ttype != 34) {
                    stok.nextToken();
                    this.setPackageType(new PackageType(stok.sval));
                }
                if ("import".equals(stok.sval) && stok.ttype != 34) {
                    stok.nextToken();
                    String name = stok.sval;
                    if (name.charAt(name.length() - 1) == '.') {
                        name = name + "*";
                    }
                    this.addImportType(new ImportType(name));
                }
                if (!"class".equals(stok.sval) && !"interface".equals(stok.sval) && !"enum".equals(stok.sval) || stok.ttype == 34) continue;
                stok.nextToken();
                this.addClassType(new ClassType(stok.sval, JavaFileImpl.getFilenameWithoutPathOrExtension(this.getFilename())));
            }
        }
        finally {
            stok = null;
            if (this.reader != null) {
                this.reader.close();
            }
        }
    }

    private static String getFilenameWithoutPathOrExtension(String filename) {
        int extensionIndex = filename.lastIndexOf(".java");
        String newFilename = extensionIndex == -1 ? filename : filename.substring(0, extensionIndex);
        int pathIndex = (newFilename = StringUtils.replace((String)newFilename, (String)"\\", (String)"/")).lastIndexOf("/");
        if (pathIndex == -1) {
            return newFilename;
        }
        return newFilename.substring(pathIndex + 1);
    }

    private StreamTokenizer getTokenizer() throws IOException {
        if (!new File(this.getFilename()).exists()) {
            throw new IOException(this.getFilename() + " does not exist!");
        }
        this.reader = this.getEncoding() != null ? new InputStreamReader((InputStream)new FileInputStream(this.getFilename()), this.getEncoding()) : new FileReader(this.getFilename());
        StreamTokenizer stok = new StreamTokenizer(this.reader);
        stok.commentChar(42);
        stok.wordChars(95, 95);
        stok.slashStarComments(true);
        stok.slashSlashComments(true);
        return stok;
    }
}

