/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.pogamut.ut3.agent.module.shooting.weapon;

import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Weaponry;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.WeaponPref;
import cz.cuni.amis.pogamut.ut2004.bot.command.ImprovedShooting;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut3.communication.messages.UT3ItemType;
import nl.tudelft.pogamut.unreal.agent.module.shooting.AbstractWeaponShooting;
import nl.tudelft.pogamut.unreal.agent.module.shooting.util.FacingUtil;

public class LinkGunShooting
extends AbstractWeaponShooting {
    protected static final int SHIELD_GUN_DEFLECT_ANGLE = 90;
    protected static final int LINK_GUN_SEC_MAX_RANGE = 1150;
    protected static final WeaponPref LINK_GUN_SECONDARY = new WeaponPref((ItemType)UT3ItemType.LINK_GUN, false);
    protected static final WeaponPref LINK_GUN_PRIMARY = new WeaponPref((ItemType)UT3ItemType.LINK_GUN, true);
    private static final double LINK_GUN_FACING_ANGLE = 15.0;
    private static final double LINK_GUN_WIDE_FACING_ANGLE = 25.0;

    public LinkGunShooting(UT2004Bot<?, ?, ?> bot, AgentInfo info, ImprovedShooting shoot, Weaponry weaponry) {
        super(bot, info, shoot, weaponry);
    }

    protected void shoot() {
        boolean closeEnough;
        if (!this.isWeaponReady()) {
            return;
        }
        if (!this.hasTarget()) {
            this.shoot.stopShooting();
            return;
        }
        if (!(this.target instanceof Player)) {
            this.shoot.shoot(this.weaponPref, this.target);
            return;
        }
        Player player = (Player)this.target;
        if (!player.isVisible()) {
            this.shoot.stopShooting();
            return;
        }
        if (this.info.isFriend(player)) {
            this.shootFriend(player);
            return;
        }
        if (!FacingUtil.isFacing2D((AgentInfo)this.info, (ILocated)this.target, (double)15.0)) {
            this.shoot.stopShooting();
            return;
        }
        boolean bl = closeEnough = this.info.getLocation().getDistance(player.getLocation()) < 1150.0;
        if (closeEnough) {
            this.shoot.shoot(LINK_GUN_SECONDARY, this.target);
        } else {
            this.shoot.shoot(LINK_GUN_PRIMARY, this.target);
        }
    }

    protected void shootFriend(Player player) {
        if (this.canAssist(player) && FacingUtil.isFacing2D((AgentInfo)this.info, (ILocated)this.target, (double)25.0)) {
            this.shoot.shoot(LINK_GUN_SECONDARY, (ILocated)player);
        } else {
            this.shoot.stopShooting();
        }
    }

    protected boolean canAssist(Player player) {
        if (player == null) {
            return false;
        }
        boolean friend = this.info.isFriend(player);
        boolean hasLinkGun = UT3ItemType.LINK_GUN.equals((Object)UT3ItemType.getItemType((String)player.getWeapon()));
        boolean closeEnough = this.info.getLocation().getDistance(player.getLocation()) < 1150.0;
        return friend && hasLinkGun && closeEnough;
    }

    protected WeaponPref getDefaultWeaponPref() {
        return LINK_GUN_PRIMARY;
    }
}

