package nl.tudelft.pogamut.ut3.agent.module.shooting.weapon;

import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Weaponry;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.WeaponPref;
import cz.cuni.amis.pogamut.ut2004.bot.command.ImprovedShooting;
import nl.tudelft.pogamut.unreal.agent.module.shooting.AbstractWeaponShooting;
import nl.tudelft.pogamut.unreal.agent.module.shooting.util.FacingUtil;

import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut3.communication.messages.UT3ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;

/**
 *
 * <p>
 * Module to work efficiently with the sniper rifle.
 * </p>
 *
 * <p>
 * The sniper rifle is merely a point & click weapon so this module does just
 * that. As the secondary fire mode merely zooms in, it is not used.
 * </p>
 *
 * TODO: Sort out effects of secondary fire mode on accuracy.
 *
 *
 * @author mpkorstanje
 *
 */
public class SniperRifleShooting extends AbstractWeaponShooting {

    protected static final WeaponPref DEFAULT_WEAPON_PREF = new WeaponPref(UT3ItemType.SNIPER_RIFLE, true);

    public SniperRifleShooting(UT2004Bot<?, ?, ?> agent, AgentInfo info, ImprovedShooting shoot, Weaponry weaponry) {
        super(agent, info, shoot, weaponry);
    }

    @Override
    protected void shoot() {

        // Wrong weapon, wait up.
        if (!isWeaponReady()) {
            return;
        }

        // No target, no shoot.
        if (!hasTarget()) {
            shoot.stopShooting();
            return;
        }

        if (!(target instanceof Player)) {
            shoot.shoot(target);
            return;
        }

        Player player = (Player) target;

        // Target not visible, hold fire.
        if (!player.isVisible() || !FacingUtil.isFacing2D(info, target, FACING_ANGLE)) {
            shoot.stopShooting();
        } else {
            shoot.shoot(target);
        }
    }

    @Override
    protected WeaponPref getDefaultWeaponPref() {
        return DEFAULT_WEAPON_PREF;
    }
}
