package nl.tudelft.pogamut.ut3.agent.module.shooting.weapon;

import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Weaponry;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.WeaponPref;
import cz.cuni.amis.pogamut.ut2004.bot.command.ImprovedShooting;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut3.communication.messages.UT3ItemType;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import nl.tudelft.pogamut.unreal.agent.module.shooting.AbstractWeaponShooting;

/**
 *
 * @author Evers
 */
public class SlowVolumeShooting extends AbstractWeaponShooting {

    protected static final WeaponPref SLOWVOLUME_PRIMARY = new WeaponPref(UT3ItemType.SLOW_VOLUME, true);

    public SlowVolumeShooting(UT2004Bot<?, ?, ?> agent, AgentInfo info, ImprovedShooting shoot, Weaponry weaponry) {
        super(agent, info, shoot, weaponry);
    }

    @Override
    protected void shoot() {
        // Wrong weapon, wait up.
        if (!isWeaponReady()) {
            return;
        }

        if (!hasTarget()) {
            shoot.stopShooting();
            return;
        }

        if (!(target instanceof Player)) {
            shoot.shoot(target);
            return;
        }

        Player player = (Player) target;
        
        if (!player.isVisible()) {
            shoot.stopShooting();
        } else {
            shoot.shoot(weaponPref, target);
        } 
    }

    @Override
    protected WeaponPref getDefaultWeaponPref() {
        return SLOWVOLUME_PRIMARY;
    }
}
