package nl.tudelft.pogamut.ut3.agent.module.sensor;

import java.util.Collection;
import nl.tudelft.pogamut.unreal.agent.module.sensor.Projectiles;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut3.communication.messages.UT3ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType.Category;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.IncomingProjectile;
import cz.cuni.amis.utils.IFilter;
import cz.cuni.amis.utils.collections.MyCollections;

/**
 * Module to keep track of projectiles.
 *
 * TODO: Horribly inefficient, use listeners. TODO: Needs ILocated on
 * {@link IncomingProjectile}.
 *
 * @author mpkorstanje
 *
 */
@SuppressWarnings("rawtypes")
public class UT3Projectiles extends Projectiles  {

    public UT3Projectiles(UT2004Bot<?, ?, ?> agent, AgentInfo info) {
        super(agent,info);
        this.info = info;
    }

    public Collection<IncomingProjectile> getProjectiles(final ItemType type) {
        if (type == null) {
            return null;
        }
        if (type.getCategory() != Category.PROJECTILE) {
            return null;
        }

        return MyCollections.getFiltered(worldView.getAll(IncomingProjectile.class).values(), new IFilter<IncomingProjectile>() {
            @Override
            public boolean isAccepted(IncomingProjectile object) {
                return type.equals(UT3ItemType.getItemType(object.getType()));
            }
        });
    }}
