package nl.tudelft.pogamut.ut3.agent.module.shooting.weapon;

import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Weaponry;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.WeaponPref;
import cz.cuni.amis.pogamut.ut2004.bot.command.ImprovedShooting;
import nl.tudelft.pogamut.unreal.agent.module.shooting.AbstractWeaponShooting;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut3.communication.messages.UT3ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;

public class StingerMinigunShooting extends AbstractWeaponShooting {

    protected static final WeaponPref STINGER_MINIGUN_PRIMARY = new WeaponPref(UT3ItemType.STINGER_MINIGUN, true);
    protected static final WeaponPref STINGER_MINIGUN_SECONARY = new WeaponPref(UT3ItemType.STINGER_MINIGUN, false);

    public StingerMinigunShooting(UT2004Bot<?, ?, ?> agent, AgentInfo info, ImprovedShooting shoot, Weaponry weaponry) {
        super(agent, info, shoot, weaponry);
    }

    @Override
    protected void shoot() {

        // Wrong weapon, wait up.
        if (!isWeaponReady()) {
            return;
        }

        // No target, no shoot.
        if (!hasTarget()) {
            shoot.stopShooting();
            return;
        }

        if (!(target instanceof Player)) {
            shoot.shoot(target);
            return;
        }

        Player player = (Player) target;

        // Target not visible, hold fire.
        // Keep firing even if not facing, gives time to spin up minigun.
        if (!player.isVisible()) {
            shoot.stopShooting();            
        } else {
            shoot.shoot(weaponPref, target);
        }
    }

    @Override
    protected WeaponPref getDefaultWeaponPref() {
        return STINGER_MINIGUN_PRIMARY;
    }
}
