package nl.tudelft.pogamut.ut3.agent.module.shooting.weapon;

import nl.tudelft.pogamut.unreal.agent.module.shooting.AbstractWeaponShooting;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Weaponry;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.WeaponPref;
import cz.cuni.amis.pogamut.ut2004.bot.command.ImprovedShooting;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut3.communication.messages.UT3ItemType;

/**
 * <p>
 * Module to work efficiently with the shield gun.
 * </p>
 * 
 * <p>
 * When the primary mode is given to the weapon preferences the shield gun will
 * simply charge up. It's up to other component to run into someone.
 * </p>
 * <p>
 * When the secondary mode is requested by weapon preferences the shield gun
 * activate for 1 second when ever it detects that it is taking damage, sees an
 * incoming projectile or sees it's target shooting or sees it's target aiming a
 * hitscan weapon at it. While doing this the bot will aim in the direction of
 * its target, potentially bouncing shock cores and link gun projectiles to it's
 * target.
 * </p>
 * 
 * @author mpkorstanje
 * 
 */
public class ImpactHammerShooting extends AbstractWeaponShooting {

	/**
	 * Default is the secondary mode.
	 */
	protected static final WeaponPref DEFAULT_WEAPON_PREF = new WeaponPref(UT3ItemType.IMPACT_HAMMER, false);



	public ImpactHammerShooting(UT2004Bot<?, ?, ?> bot, AgentInfo info, ImprovedShooting shoot, Weaponry weaponry) {
		super(bot, info, shoot, weaponry);

	}

	@Override
	protected void shoot() {

		// Wrong weapon, wait up.
		if (!isWeaponReady()) {
			return;
		}

		// Reset focus
		focus.setFocus(target);

		// Primary works by running into people, just keep it charged.
		if (weaponPref.isPrimary()) {
			shootPrimary();
		}
		// Secondary works by running into people, just keep it charged.
		else {
			shootSecondary();
		}

	}

	protected void shootPrimary() {
		if (target == null) {
			shoot.shoot();
			return;
		}

		shoot.shootPrimary(target);

	}

	protected void shootSecondary() {

		if (target == null) {
			shoot.shootSecondary();
			return;
		}

		shoot.shootSecondary(target);

	}

	@Override
	protected WeaponPref getDefaultWeaponPref() {
		return DEFAULT_WEAPON_PREF;
	}

}
