package nl.tudelft.pogamut.ut3.agent.module.shooting.weapon;

import nl.tudelft.pogamut.unreal.agent.module.shooting.AbstractWeaponShooting;
import nl.tudelft.pogamut.unreal.agent.module.shooting.util.FacingUtil;

import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Weaponry;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.WeaponPref;
import cz.cuni.amis.pogamut.ut2004.bot.command.ImprovedShooting;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut3.communication.messages.UT3ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;

/**
 * <p>
 * Module to work efficiently with the flak cannon.
 * </p>
 *
 * <p>
 * To avoid self damage the module won't use the secondary fire mode when it
 * might blow up in it's face and won't be able to survive the damage. Instead
 * secondary mode will be used. The effectiveness of this is somewhat limited as
 * flak cannon projectiles bounce around.
 *
 * Consider using {@link WeaponPrefs} to ban the flak cannon on close range.
 * <p>
 *
 * @author mpkorstanje
 *
 */
public class FlakCannonShooting extends AbstractWeaponShooting {

    protected static final WeaponPref FLAK_CANNON_PRIMARY = new WeaponPref(UT3ItemType.FLAK_CANNON, true);
    protected static final double FLAK_CANON_SECONDARY_PROJECTILE_SPLASH_RADIUS = 400;
    protected static final int FLAK_CANON_SECONDARY_PROJECTILE_DAMAGE = 75;

    public FlakCannonShooting(UT2004Bot<?, ?, ?> agent, AgentInfo info, ImprovedShooting shoot, Weaponry weaponry) {
        super(agent, info, shoot, weaponry);
    }

    @Override
    protected void shoot() {

        // Wrong weapon, wait up.
        if (!isWeaponReady()) {
            return;
        }

        //No target, no shoot.
        if (!hasTarget()) {
            shoot.stopShooting();
            return;
        }

        boolean facing = FacingUtil.isFacing2D(info, target, FACING_ANGLE);
        boolean safeToShoot = isSafeToShoot(target);

        if (!(target instanceof Player)) {
            shootLocation(facing, safeToShoot);
            return;
        }

        Player player = (Player) target;

        // Target not visible, hold fire.
        if (!player.isVisible()) {
            shoot.stopShooting();
            return;
        }

        // Shoot if we are facing the right way.
        // Don't want to blow an orb on a wall.
        if (facing && safeToShoot) {
            shoot.shoot(weaponPref, player);
        } // Player will absorb damage. So fall back to primary.
        else if (facing) {
            shoot.shootPrimary(player);
        } else {
            shoot.stopShooting();
        }
    }

    private void shootLocation(boolean facing, boolean safeToShoot) {
        if (facing && safeToShoot) {
            shoot.shoot(weaponPref, target);
        } // Don't alternate to primary when note safe to shoot. Primary only gets
        // absorbed by players.
        else {
            shoot.stopShooting();
        }
    }

    /**
     * Don't shoot unless we are far away enough to avoid damaging ourselves, or
     * healthy enough to survive the damage.
     *
     * @param target to shoot
     * @return true iff we won't kill ourselves.
     */
    protected boolean isSafeToShoot(ILocated target) {
        double distance = info.getLocation().getDistance(target.getLocation());
        boolean safeDistance = distance > FLAK_CANON_SECONDARY_PROJECTILE_SPLASH_RADIUS;
        boolean healty = info.getHealth() > FLAK_CANON_SECONDARY_PROJECTILE_DAMAGE;

        return (safeDistance || healty);
    }

    @Override
    protected WeaponPref getDefaultWeaponPref() {
        return FLAK_CANNON_PRIMARY;
    }
}
