package nl.tudelft.pogamut.ut3.agent.module.shooting.weapon;

import nl.tudelft.pogamut.unreal.agent.module.shooting.AbstractWeaponShooting;
import nl.tudelft.pogamut.unreal.agent.module.shooting.util.FacingUtil;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Weaponry;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.WeaponPref;
import cz.cuni.amis.pogamut.ut2004.bot.command.ImprovedShooting;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut3.communication.messages.UT3ItemType;

public class BioRifleShooting extends AbstractWeaponShooting {

    protected static final WeaponPref BIO_RIFLE_PRIMARY = new WeaponPref(UT3ItemType.BIO_RIFLE, true);
    protected static final double BIO_RIFLE_SPLASH_RADIUS = 200;
    private static final int BIO_RIFLE_SPLASH_DAMAGE = 75;

    public BioRifleShooting(UT2004Bot<?, ?, ?> agent, AgentInfo info, ImprovedShooting shoot, Weaponry weaponry) {
        super(agent, info, shoot, weaponry);
    }

    @Override
    protected void shoot() {

        // Wrong weapon, wait up.
        if (!isWeaponReady()) {
            return;
        }

        // Charge secondary.
        if (!hasTarget() && weaponPref.isSecondary()) {
            chargeSecondary();
            return;
        } // No target, no shoot.
        else if (!hasTarget()) {
            shoot.stopShooting();
            return;
        }

        boolean facing = FacingUtil.isFacing2D(info, target, FACING_ANGLE);
        boolean close = info.getLocation().getDistance(target.getLocation()) < BIO_RIFLE_SPLASH_RADIUS;
        boolean healthy = info.getHealth() > BIO_RIFLE_SPLASH_DAMAGE;
        boolean safe = !close || healthy;

        if (!(target instanceof Player)) {
            shootTarget(target, facing, safe);
            return;
        }

        Player player = (Player) target;

        if (weaponPref.isPrimary()) {
            shootPrimary(player, facing, safe);
        } else {
            shootSecondary(player, facing, safe);
        }
    }

    /**
     * Shoots primary mode at the target, if we are facing it. Secondary mode
     * makes no sense. Will not blow a secondary charge if it is not safe to do
     * so.
     *
     * @param target
     * @param facing
     */
    protected void shootTarget(ILocated target, boolean facing, boolean safe) {
        if (facing && safe) {
            shoot.shootPrimary(target);
        } else if (!info.isSecondaryShooting()) {
            shoot.stopShooting();
        }
    }

    /**
     * Starts shooting secondary mode.
     */
    protected void chargeSecondary() {
        shoot.shootSecondary();
    }

    /**
     * Shoots a visible player we are facing with the primary mode, otherwise
     * charges up using secondary.
     *
     * @param player
     * @param facing
     */
    protected void shootSecondary(Player player, boolean facing, boolean safe) {
        // Use primary to shoot visible players.
        // This will cause the first shot to be a charged shot.
        if (player.isVisible() && facing && safe) {
            shoot.shootPrimary(player);
        } else {
            chargeSecondary();
        }
    }

    /**
     * Shoots primary when it is safe to do so. If secondary was previously
     * shooting it won't blow the charge prematurely.
     *
     * @param player
     * @param facing
     */
    protected void shootPrimary(Player player, boolean facing, boolean safe) {
        if (player.isVisible() && facing && safe) {
            shoot.shootPrimary(target);
        } else if (!info.isSecondaryShooting()) {
            shoot.stopShooting();
        }
    }

    @Override
    protected WeaponPref getDefaultWeaponPref() {
        return BIO_RIFLE_PRIMARY;
    }
}
