package nl.tudelft.pogamut.ut2004.agent.module.shooting;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

import nl.tudelft.pogamut.unreal.agent.module.sensor.Projectiles;
import nl.tudelft.pogamut.unreal.agent.module.shooting.WeaponryShooting;
import nl.tudelft.pogamut.ut2004.agent.module.sensor.UT2004Projectiles;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.weapon.AssaultRifleShooting;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.weapon.BioRifleShooting;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.weapon.FlakCannonShooting;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.weapon.IonPainterShooting;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.weapon.LigthningGunShooting;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.weapon.LinkGunShooting;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.weapon.MinigunShooting;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.weapon.ReedeemerShooting;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.weapon.RocketLauncherShooting;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.weapon.ShieldGunShooting;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.weapon.ShockRifleShooting;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.weapon.SniperRifleShooting;
import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.module.utils.TabooSet;
import cz.cuni.amis.pogamut.ut2004.bot.UT2004BotTestController;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.AddInventory;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.utils.Heatup;
import cz.cuni.amis.utils.collections.MyCollections;
import cz.cuni.amis.utils.exception.PogamutException;

/**
 * Test controller for various {@link WeaponShooting}s. Agents will follow a
 * path and shoot each other. With some special bits for the shield gun and link
 * gun.
 * 
 * At the end of the test after the testduration the controller checks if bot
 * has made at least one kill (if he had a weapon capable of doing so). If so,
 * the bot passes the test.
 * 
 * @author mpkorstanje
 * 
 */
@SuppressWarnings("rawtypes")
public abstract class WeaponShootingTestController extends
		UT2004BotTestController<UT2004Bot> {

	protected WeaponryShooting weaponShooting;
	private Projectiles projectiles;
	private WeaponShootingParameters parameters;
	protected ItemType weapon;
	protected ItemType ammo;
	protected boolean primary;
	protected List<NavPoint> firingRange;
	protected TabooSet<NavPoint> visited;
	protected Heatup waitAtLocation;
	private Heatup testDuration;

	protected NavPoint currentStation;
	private boolean needsKills = true;

	public WeaponShootingTestController() {
		super();
	}

	protected void initializeModules(UT2004Bot bot) {
		super.initializeModules(bot);
		projectiles = new UT2004Projectiles(bot, info);
		weaponShooting = new WeaponryShooting(bot, info, weaponry, weaponPrefs,
				shoot);

		initializeWeaponShootings();
	}

	protected void initializeWeaponShootings() {
		weaponShooting.addWeaponShooting(new LinkGunShooting(bot, info, shoot,
				weaponry));
		weaponShooting.addWeaponShooting(new ShockRifleShooting(bot, info,
				shoot, weaponry, projectiles));
		weaponShooting.addWeaponShooting(new MinigunShooting(bot, info, shoot,
				weaponry));
		weaponShooting.addWeaponShooting(new FlakCannonShooting(bot, info,
				shoot, weaponry));
		weaponShooting.addWeaponShooting(new ShieldGunShooting(bot, info,
				shoot, weaponry, projectiles, senses));
		weaponShooting.addWeaponShooting(new BioRifleShooting(bot, info, shoot,
				weaponry));
		weaponShooting.addWeaponShooting(new AssaultRifleShooting(bot, info,
				shoot, weaponry));
		weaponShooting.addWeaponShooting(new RocketLauncherShooting(bot, info,
				shoot, weaponry));
		weaponShooting.addWeaponShooting(new LigthningGunShooting(bot, info,
				shoot, weaponry));
		weaponShooting.addWeaponShooting(new SniperRifleShooting(bot, info,
				shoot, weaponry));
		weaponShooting.addWeaponShooting(new ReedeemerShooting(bot, info,
				shoot, weaponry));
		weaponShooting.addWeaponShooting(new IonPainterShooting(bot, info,
				shoot, weaponry));
	}

	@Override
	public void finishControllerInitialization() {
		super.finishControllerInitialization();

		// Connects focus. Focus is self updating. Important: if you change
		// focus, don't forget to set it back. But should be no need too change
		// focus.
		navigation.setFocus(weaponShooting.getFocus());
	}

	public void prepareBot(UT2004Bot bot) {
		parameters = (WeaponShootingParameters) bot.getParams();
		weapon = parameters.getWeapon();
		ammo = parameters.getAmmo();
		primary = parameters.isPrimary();
		visited = new TabooSet<NavPoint>(bot);
		waitAtLocation = new Heatup(parameters.getWaitAtLocation(),
				TimeUnit.SECONDS);
		testDuration = new Heatup(parameters.getTestDuration(),
				TimeUnit.MINUTES);
	}

	@Override
	public Initialize getInitializeCommand() {

		return new Initialize().setTeam(parameters.getTeam());
	}

	@Override
	public void beforeFirstLogic() {
		firingRange = new ArrayList<NavPoint>();
		for (String id : parameters.getFiringRange()) {
			NavPoint nav = world.get(UnrealId.get(id), NavPoint.class);
			if (nav == null) {
				setFailure("Navpoint " + id + " does not exist");
			}
			firingRange.add(nav);
		}

		currentStation = MyCollections.getRandom(firingRange);

		weaponPrefs.addGeneralPref(weapon, primary);

		testDuration.heat();
	}

	@Override
	public void logic() throws PogamutException {

		// Done yet?
		if (checkTestComplete()) {
			return;
		}

		// Pratice targets
		if (parameters.isPracticeTarget()) {
			logicShieldSecondary();
			return;
		}

		logicTestWeapon();
	}

	public abstract void logicTestWeapon();

	private void logicShieldSecondary() {
		Player player = players.getNearestVisibleEnemy();

		if (player != null) {
			weaponShooting.shoot(player);
		}

		// Move from point to point
		if (!info.atLocation(currentStation)) {
			navigation.navigate(currentStation);
			waitAtLocation.heat();
			return;
		}

		// Done waiting.
		if (waitAtLocation.isCool()) {
			visited.add(currentStation);
			currentStation = DistanceUtils.getNearest(
					visited.filter(firingRange), bot);
			if (currentStation == null) {
				visited.clear();
				currentStation = MyCollections.getRandom(visited
						.filter(firingRange));
			}
			return;
		}

		// Look for some target.
		move.turnHorizontal(30);

	}

	protected boolean checkTestComplete() {
		if (testDuration.isHot()) {
			return false;
		}

		if (parameters.isPracticeTarget() || needsKills()) {
			return false;
		}

		this.setSuccess(String
				.format("Test ran for %s minutes without errors. Bot killed %s people.",
						parameters.getTestDuration(), info.getKills()));
		return true;

	}

	public boolean needsKills() {
		return needsKills;
	}

	protected void setNeedsKills(boolean needsKills) {
		this.needsKills = needsKills;
	}

	protected void addWeapon() {
		if (!weaponry.hasWeapon(weapon)) {
			getAct().act(new AddInventory().setType(weapon.getName()));
		}
	}

	protected void addAmmo() {
		if (!weaponry.hasAmmoForWeapon(weapon)) {
			getAct().act(new AddInventory().setType(ammo.getName()));
			getAct().act(new AddInventory().setType(weapon.getName()));
		}
	}

}