/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.pogamut.ut2004.agent.module.shooting.weapon;

import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Weaponry;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.WeaponPref;
import cz.cuni.amis.pogamut.ut2004.bot.command.ImprovedShooting;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.IncomingProjectile;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import nl.tudelft.pogamut.ut2004.agent.module.sensor.Projectiles;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.AbstractWeaponShooting;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.util.FacingUtil;

public class ShockRifleShooting
extends AbstractWeaponShooting {
    protected static final int SHIELD_GUN_DEFLECT_ANGLE = 90;
    protected static final WeaponPref SHOCK_RIFLE_PRIMARY = new WeaponPref(ItemType.SHOCK_RIFLE, true);
    protected static final WeaponPref SHOCK_RIFLE_SECONDARY = new WeaponPref(ItemType.SHOCK_RIFLE, false);
    protected static final double SHOCK_RIFLE_COMBO_RADIUS = 300.0;
    protected static final double SHOCK_RIFLE_PROJECTILE_SPLASH_RADIUS = 150.0;
    protected static final int SHOCK_RIFLE_PROJECTILE_DAMAGE = 35;
    protected static final int SHOCK_RIFLE_MIN_DISTANCE_COMBO = 900;
    protected Projectiles projectiles;
    protected Location lastLocation;

    public ShockRifleShooting(UT2004Bot<?, ?, ?> bot, AgentInfo info, ImprovedShooting shoot, Weaponry weaponry, Projectiles projectiles) {
        super(bot, info, shoot, weaponry);
        this.weaponry = weaponry;
        this.projectiles = projectiles;
    }

    @Override
    protected void shoot() {
        if (!this.isWeaponReady()) {
            return;
        }
        if (!this.hasTarget() && this.shootCombo((ILocated)this.lastLocation)) {
            return;
        }
        this.lastLocation = null;
        if (!this.hasTarget()) {
            this.shoot.stopShooting();
            return;
        }
        this.focus.setFocus(this.target);
        boolean safeToSHoot = this.isSafeToShoot(this.target, this.weaponPref);
        boolean facing = FacingUtil.isFacing2D(this.info, this.target, 30.0);
        if (!(this.target instanceof Player)) {
            this.shootTarget(safeToSHoot, facing);
            return;
        }
        Player player = (Player)this.target;
        if (this.shootCombo((ILocated)player)) {
            return;
        }
        if (!player.isVisible()) {
            this.shoot.stopShooting();
            return;
        }
        this.lastLocation = player.getLocation();
        boolean targetFacing = FacingUtil.isFacing2D(player, (ILocated)this.agent, 90.0);
        boolean targetShieldGun = ItemType.SHIELD_GUN.equals((Object)ItemType.getItemType((String)player.getWeapon()));
        boolean targetShielded = player.getFiring() == 2;
        boolean targetCanDeflect = targetShieldGun && targetFacing && targetShielded;
        this.shootPlayer(safeToSHoot, targetCanDeflect, facing);
    }

    protected void shootPlayer(boolean safeToSHoot, boolean canDeflect, boolean facing) {
        if (!canDeflect) {
            this.shootTarget(safeToSHoot, facing);
        } else {
            this.shootShieldedPlayer(safeToSHoot, facing);
        }
    }

    protected void shootShieldedPlayer(boolean safeToSHoot, boolean facing) {
        boolean inComboRange = this.target.getLocation().getDistance(((UT2004Bot)this.agent).getLocation()) >= 600.0;
        this.log.fine(String.format("Shooting shielded player. safeToSHoot=%s facing=%s inComboRange=%s", safeToSHoot, facing, inComboRange));
        if (inComboRange && safeToSHoot && facing && this.weaponPref.isSecondary()) {
            this.shoot.shoot(this.weaponPref, (ILocated)this.target.getLocation().add(ABOVE_PLAYER_OFFSET));
        } else {
            this.shoot.stopShooting();
        }
    }

    protected void shootTarget(boolean safeToSHoot, boolean facing) {
        this.log.fine(String.format("Shooting target. safeToSHoot=%s facing=%s ", safeToSHoot, facing));
        if (safeToSHoot && facing) {
            this.shoot.shoot(this.weaponPref, this.target);
        } else if (facing) {
            this.shoot.shoot(SHOCK_RIFLE_PRIMARY, this.target);
        } else {
            this.shoot.stopShooting();
        }
    }

    protected boolean isSafeToShoot(ILocated target, WeaponPref weaponPref) {
        boolean primary = weaponPref.isPrimary();
        double distance = this.info.getLocation().getDistance(target.getLocation());
        boolean safeDistance = distance > 150.0;
        boolean healty = this.info.getHealth() > 35;
        return primary || safeDistance || healty;
    }

    protected boolean shootCombo(ILocated target) {
        if (target == null || target.getLocation() == null) {
            this.log.fine("No valid target");
            return false;
        }
        IncomingProjectile projectile = this.projectiles.getNearestProjectile(target, ItemType.SHOCK_RIFLE_PROJECTILE);
        if (projectile == null) {
            this.log.fine("No valid projectile to shoot");
            return false;
        }
        double distanceOrbTarget = projectile.getLocation().getDistance(target.getLocation());
        double distanceSelfTarget = this.info.getLocation().getDistance(target.getLocation());
        double distanceSelfOrb = this.info.getLocation().getDistance(projectile.getLocation());
        boolean orbPassedTarget = distanceSelfOrb > distanceSelfTarget + 300.0;
        boolean targetInComboRadius = distanceOrbTarget < 300.0;
        this.log.fine(String.format("Selected projectile: %s", projectile));
        this.log.fine(String.format("Projectile has passed target? %s", orbPassedTarget));
        this.log.fine(String.format("Target in combo radius? %s", targetInComboRadius));
        if (!orbPassedTarget && !targetInComboRadius) {
            this.log.fine("Waiting for projectile to close in on target");
            this.shoot.stopShooting();
            this.focus.setFocus((ILocated)projectile);
            return true;
        }
        if (!orbPassedTarget) {
            this.log.fine("Shoot rojectile");
            this.shoot.shoot(SHOCK_RIFLE_PRIMARY, projectile.getId());
            return true;
        }
        return false;
    }

    @Override
    protected WeaponPref getDefaultWeaponPref() {
        return SHOCK_RIFLE_SECONDARY;
    }
}

