/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.pogamut.ut2004.agent.module.shooting;

import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.module.utils.TabooSet;
import cz.cuni.amis.pogamut.ut2004.bot.UT2004BotTestController;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.AddInventory;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.utils.Heatup;
import cz.cuni.amis.utils.collections.MyCollections;
import cz.cuni.amis.utils.exception.PogamutException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import nl.tudelft.pogamut.ut2004.agent.module.sensor.Projectiles;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.WeaponShooting;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.WeaponShootingParameters;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.WeaponryShooting;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.weapon.AssaultRifleShooting;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.weapon.BioRifleShooting;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.weapon.FlakCannonShooting;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.weapon.IonPainterShooting;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.weapon.LigthningGunShooting;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.weapon.LinkGunShooting;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.weapon.MinigunShooting;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.weapon.ReedeemerShooting;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.weapon.RocketLauncherShooting;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.weapon.ShieldGunShooting;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.weapon.ShockRifleShooting;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.weapon.SniperRifleShooting;

public abstract class WeaponShootingTestController
extends UT2004BotTestController<UT2004Bot> {
    protected WeaponryShooting weaponShooting;
    private Projectiles projectiles;
    private WeaponShootingParameters parameters;
    protected ItemType weapon;
    protected ItemType ammo;
    protected boolean primary;
    protected List<NavPoint> firingRange;
    protected TabooSet<NavPoint> visited;
    protected Heatup waitAtLocation;
    private Heatup testDuration;
    protected NavPoint currentStation;
    private boolean needsKills = true;

    protected void initializeModules(UT2004Bot bot) {
        super.initializeModules(bot);
        this.projectiles = new Projectiles(bot, this.info);
        this.weaponShooting = new WeaponryShooting(bot, this.info, this.weaponry, this.weaponPrefs, this.shoot);
        this.initializeWeaponShootings();
    }

    protected void initializeWeaponShootings() {
        this.weaponShooting.addWeaponShooting((WeaponShooting)new LinkGunShooting(this.bot, this.info, this.shoot, this.weaponry));
        this.weaponShooting.addWeaponShooting((WeaponShooting)new ShockRifleShooting(this.bot, this.info, this.shoot, this.weaponry, this.projectiles));
        this.weaponShooting.addWeaponShooting((WeaponShooting)new MinigunShooting(this.bot, this.info, this.shoot, this.weaponry));
        this.weaponShooting.addWeaponShooting((WeaponShooting)new FlakCannonShooting(this.bot, this.info, this.shoot, this.weaponry));
        this.weaponShooting.addWeaponShooting((WeaponShooting)new ShieldGunShooting(this.bot, this.info, this.shoot, this.weaponry, this.projectiles, this.senses));
        this.weaponShooting.addWeaponShooting((WeaponShooting)new BioRifleShooting(this.bot, this.info, this.shoot, this.weaponry));
        this.weaponShooting.addWeaponShooting((WeaponShooting)new AssaultRifleShooting(this.bot, this.info, this.shoot, this.weaponry));
        this.weaponShooting.addWeaponShooting((WeaponShooting)new RocketLauncherShooting(this.bot, this.info, this.shoot, this.weaponry));
        this.weaponShooting.addWeaponShooting((WeaponShooting)new LigthningGunShooting(this.bot, this.info, this.shoot, this.weaponry));
        this.weaponShooting.addWeaponShooting((WeaponShooting)new SniperRifleShooting(this.bot, this.info, this.shoot, this.weaponry));
        this.weaponShooting.addWeaponShooting((WeaponShooting)new ReedeemerShooting(this.bot, this.info, this.shoot, this.weaponry));
        this.weaponShooting.addWeaponShooting((WeaponShooting)new IonPainterShooting(this.bot, this.info, this.shoot, this.weaponry));
    }

    public void finishControllerInitialization() {
        super.finishControllerInitialization();
        this.navigation.setFocus(this.weaponShooting.getFocus());
    }

    public void prepareBot(UT2004Bot bot) {
        this.parameters = (WeaponShootingParameters)bot.getParams();
        this.weapon = this.parameters.getWeapon();
        this.ammo = this.parameters.getAmmo();
        this.primary = this.parameters.isPrimary();
        this.visited = new TabooSet(bot);
        this.waitAtLocation = new Heatup(this.parameters.getWaitAtLocation(), TimeUnit.SECONDS);
        this.testDuration = new Heatup(this.parameters.getTestDuration(), TimeUnit.MINUTES);
    }

    public Initialize getInitializeCommand() {
        return new Initialize().setTeam(this.parameters.getTeam());
    }

    public void beforeFirstLogic() {
        this.firingRange = new ArrayList<NavPoint>();
        for (String id : this.parameters.getFiringRange()) {
            NavPoint nav = (NavPoint)this.world.get((WorldObjectId)UnrealId.get((String)id), NavPoint.class);
            if (nav == null) {
                this.setFailure("Navpoint " + id + " does not exist");
            }
            this.firingRange.add(nav);
        }
        this.currentStation = (NavPoint)MyCollections.getRandom(this.firingRange);
        this.weaponPrefs.addGeneralPref(this.weapon, this.primary);
        this.testDuration.heat();
    }

    public void logic() throws PogamutException {
        if (this.checkTestComplete()) {
            return;
        }
        if (this.parameters.isPracticeTarget()) {
            this.logicShieldSecondary();
            return;
        }
        this.logicTestWeapon();
    }

    public abstract void logicTestWeapon();

    private void logicShieldSecondary() {
        Player player = this.players.getNearestVisibleEnemy();
        if (player != null) {
            this.weaponShooting.shoot((ILocated)player);
        }
        if (!this.info.atLocation((ILocated)this.currentStation)) {
            this.navigation.navigate((ILocated)this.currentStation);
            this.waitAtLocation.heat();
            return;
        }
        if (this.waitAtLocation.isCool()) {
            this.visited.add((Object)this.currentStation);
            this.currentStation = (NavPoint)DistanceUtils.getNearest((Collection)this.visited.filter(this.firingRange), (ILocated)this.bot);
            if (this.currentStation == null) {
                this.visited.clear();
                this.currentStation = (NavPoint)MyCollections.getRandom((Collection)this.visited.filter(this.firingRange));
            }
            return;
        }
        this.move.turnHorizontal(30);
    }

    protected boolean checkTestComplete() {
        if (this.testDuration.isHot()) {
            return false;
        }
        if (this.parameters.isPracticeTarget() || this.needsKills()) {
            return false;
        }
        this.setSuccess(String.format("Test ran for %s minutes without errors. Bot killed %s people.", this.parameters.getTestDuration(), this.info.getKills()));
        return true;
    }

    public boolean needsKills() {
        return this.needsKills;
    }

    protected void setNeedsKills(boolean needsKills) {
        this.needsKills = needsKills;
    }

    protected void addWeapon() {
        if (!this.weaponry.hasWeapon(this.weapon)) {
            this.getAct().act((CommandMessage)new AddInventory().setType(this.weapon.getName()));
        }
    }

    protected void addAmmo() {
        if (!this.weaponry.hasAmmoForWeapon(this.weapon)) {
            this.getAct().act((CommandMessage)new AddInventory().setType(this.ammo.getName()));
            this.getAct().act((CommandMessage)new AddInventory().setType(this.weapon.getName()));
        }
    }
}

