package nl.tudelft.pogamut.unreal.agent.module.shooting.weapon;


import nl.tudelft.pogamut.unreal.agent.module.shooting.AbstractWeaponShooting;
import nl.tudelft.pogamut.unreal.agent.module.shooting.util.FacingUtil;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Weaponry;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.WeaponPref;
import cz.cuni.amis.pogamut.ut2004.bot.command.ImprovedShooting;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;

/**
 * Fall back module to handle unknown weapons. Will shoot the primary mode at
 * visible targets.
 * 
 * @author mpkorstanje
 * 
 */
public class GenericWeaponShooting extends AbstractWeaponShooting {

	protected WeaponPref weaponPref;

	public GenericWeaponShooting(UT2004Bot<?, ?, ?> agent, AgentInfo info, ImprovedShooting shoot, Weaponry weaponry,
			ItemType weapon) {
		super(agent, info, shoot, weaponry);
		weaponPref = new WeaponPref(weapon);
	}

	@Override
	protected void shoot() {
		if (!isWeaponReady()) {
			return;
		}

		// No target, no shoot.
		if (!hasTarget()) {
			shoot.stopShooting();
			return;
		}

		if (!(target instanceof Player)) {
			shoot.shoot(target);
			return;
		}

		Player player = (Player) target;

		// Target not visible, hold fire.
		if (!player.isVisible() || !FacingUtil.isFacing2D(info, target, FACING_ANGLE)) {
			shoot.stopShooting();
			return;
		} else {
			shoot.shoot(target);
		}
	}

	@Override
	protected WeaponPref getDefaultWeaponPref() {
		return weaponPref;
	}

}
