package nl.tudelft.pogamut.unreal.agent.module.sensor;

import java.util.Collection;
import java.util.Map;

import cz.cuni.amis.pogamut.base.agent.module.SensorModule;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.IncomingProjectile;

/**
 * Module to keep track of projectiles.
 * 
 * TODO: Horribly inefficient, use listeners.
 * TODO: Needs ILocated on {@link IncomingProjectile}.
 * 
 * @author mpkorstanje
 *
 */
@SuppressWarnings("rawtypes")
public abstract class Projectiles extends SensorModule<UT2004Bot> {

	protected AgentInfo info;

	public Projectiles(UT2004Bot<?, ?, ?> agent, AgentInfo info) {
		super(agent);
		this.info = info;
		//incomingProjectileListener = new IncomingProjectileListener(worldView);
	}


	public IncomingProjectile getNearestProjectile() {
		return DistanceUtils.getNearest(worldView.getAll(IncomingProjectile.class).values(), info.getLocation());
	}


	public Map<WorldObjectId, IncomingProjectile> getProjectiles() {
		return worldView.getAll(IncomingProjectile.class);
	}

	public IncomingProjectile getNearestProjectile(ILocated location) {
		return DistanceUtils.getNearest(worldView.getAll(IncomingProjectile.class).values(), location);
	}

	public IncomingProjectile getNearestProjectile(ILocated location, double maxDistance) {
		return DistanceUtils.getNearest(worldView.getAll(IncomingProjectile.class).values(), location, maxDistance);
	}


	public IncomingProjectile getNearestProjectile(ILocated location, ItemType type) {
		return DistanceUtils.getNearest(getProjectiles(type), location);
	}

	public abstract Collection<IncomingProjectile> getProjectiles(final ItemType type);
	
	
	public IncomingProjectile getNearestProjectile(ILocated location, double maxDistance, ItemType type) {
		return DistanceUtils.getNearest(getProjectiles(type), location, maxDistance);
	}




	
//	/**
//	 * {@link IncomingProjectile} listener.
//	 */
//	private class IncomingProjectileListener implements IWorldEventListener<IncomingProjectile> {
//
//		/**
//		 * Constructor. Registers itself on the given WorldView object.
//		 * 
//		 * @param worldView
//		 *            WorldView object to listen to.
//		 */
//		public IncomingProjectileListener(IWorldView worldView) {
//			// FIXME: Doesn't work.
//
//			worldView.addEventListener(IncomingProjectile.class, this);
//		}
//
//		@Override
//		public void notify(IncomingProjectile event) {
//			projectiles.add(event);
//		}
//	}
//
//	/** {@link IncomingProjectile} listener */
//	IncomingProjectileListener incomingProjectileListener;

}
