/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.ut2004.agent;

import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.EventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Weapon;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.WeaponPref;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004BotModuleController;
import cz.cuni.amis.pogamut.ut2004.bot.params.UT2004BotParameters;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.AddInventory;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.FlagInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerKilled;
import cz.cuni.amis.utils.exception.PogamutException;
import eis.eis2java.annotation.AsAction;
import eis.eis2java.annotation.AsPercept;
import eis.eis2java.translation.Filter;
import eis.eis2java.util.AllPerceptsModule;
import eis.eis2java.util.AllPerceptsProvider;
import eis.exceptions.EntityException;
import eis.exceptions.PerceiveException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import nl.tudelft.goal.unreal.messages.BotParameters;
import nl.tudelft.goal.ut2004.messages.Action;
import nl.tudelft.goal.ut2004.messages.Combo;
import nl.tudelft.goal.ut2004.messages.FireMode;
import nl.tudelft.goal.ut2004.messages.FlagState;
import nl.tudelft.goal.ut2004.messages.None;
import nl.tudelft.goal.ut2004.messages.Percept;
import nl.tudelft.goal.ut2004.messages.SelectorList;
import nl.tudelft.goal.ut2004.messages.UnrealIdOrLocation;
import nl.tudelft.goal.ut2004.messages.WeaponPrefList;
import nl.tudelft.goal.ut2004.selector.ContextSelector;
import nl.tudelft.goal.ut2004.selector.NearestEnemy;
import nl.tudelft.goal.ut2004.util.Team;
import nl.tudelft.pogamut.ut2004.agent.module.sensor.Projectiles;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.WeaponryShooting;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.util.FocusProvider;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.util.OrderedFocusProvider;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.weapon.AssaultRifleShooting;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.weapon.BioRifleShooting;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.weapon.FlakCannonShooting;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.weapon.LigthningGunShooting;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.weapon.LinkGunShooting;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.weapon.MinigunShooting;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.weapon.RocketLauncherShooting;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.weapon.ShieldGunShooting;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.weapon.ShockRifleShooting;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.weapon.SniperRifleShooting;

public class UT2004BotBehavior
extends UT2004BotModuleController<UT2004Bot>
implements AllPerceptsProvider {
    protected List<ContextSelector> targetSelector = new ArrayList<ContextSelector>();
    protected List<ContextSelector> lookSelector = new ArrayList<ContextSelector>();
    protected Projectiles projectiles;
    protected WeaponryShooting weaponShooting;
    protected FocusProvider lookFocus = new FocusProvider();
    protected OrderedFocusProvider focus = new OrderedFocusProvider();
    protected long logicIteration;
    protected AllPerceptsModule percepts;
    protected BotParameters parameters;
    private ConcurrentLinkedQueue<Action> actions = new ConcurrentLinkedQueue();
    private List<Percept> fragged = new LinkedList<Percept>();

    @Override
    public void initializeController(UT2004Bot bot) {
        super.initializeController(bot);
        IAgentLogger logger = bot.getLogger();
        UT2004BotParameters parameters = bot.getParams();
        if (parameters instanceof BotParameters) {
            this.parameters = (BotParameters)parameters;
        } else {
            this.log.warning("Provided parameters were not a subclass of UnrealGoalParameters, using defaults.");
            this.parameters = new BotParameters(logger);
        }
        BotParameters defaults = BotParameters.getDefaults(logger);
        this.parameters.assignDefaults(defaults);
    }

    @Override
    protected void initializeModules(UT2004Bot bot) {
        super.initializeModules(bot);
        this.projectiles = new Projectiles(bot, this.info);
        this.weaponShooting = new WeaponryShooting(bot, this.info, this.weaponry, this.weaponPrefs, this.shoot);
        try {
            this.percepts = new AllPerceptsModule((Object)this);
        }
        catch (EntityException e) {
            throw new PogamutException("Could not create percept module", e);
        }
        this.initializeWeaponShootings();
    }

    protected void initializeWeaponShootings() {
        this.weaponShooting.addWeaponShooting(new LinkGunShooting(this.bot, this.info, this.shoot, this.weaponry));
        this.weaponShooting.addWeaponShooting(new ShockRifleShooting(this.bot, this.info, this.shoot, this.weaponry, this.projectiles));
        this.weaponShooting.addWeaponShooting(new MinigunShooting(this.bot, this.info, this.shoot, this.weaponry));
        this.weaponShooting.addWeaponShooting(new FlakCannonShooting(this.bot, this.info, this.shoot, this.weaponry));
        this.weaponShooting.addWeaponShooting(new ShieldGunShooting(this.bot, this.info, this.shoot, this.weaponry, this.projectiles, this.senses));
        this.weaponShooting.addWeaponShooting(new BioRifleShooting(this.bot, this.info, this.shoot, this.weaponry));
        this.weaponShooting.addWeaponShooting(new AssaultRifleShooting(this.bot, this.info, this.shoot, this.weaponry));
        this.weaponShooting.addWeaponShooting(new RocketLauncherShooting(this.bot, this.info, this.shoot, this.weaponry));
        this.weaponShooting.addWeaponShooting(new LigthningGunShooting(this.bot, this.info, this.shoot, this.weaponry));
        this.weaponShooting.addWeaponShooting(new SniperRifleShooting(this.bot, this.info, this.shoot, this.weaponry));
    }

    @Override
    public void finishControllerInitialization() {
        super.finishControllerInitialization();
        this.focus.add(this.weaponShooting.getFocus());
        this.focus.add(this.lookFocus);
        this.navigation.setFocus(this.focus);
    }

    @Override
    public Initialize getInitializeCommand() {
        assert (this.parameters != null);
        Initialize init = super.getInitializeCommand();
        init.setDesiredSkill(this.parameters.getSkill());
        init.setSkin(this.parameters.getSkin().getUnrealName());
        init.setTeam(this.parameters.getTeam());
        init.setShouldLeadTarget(this.parameters.shouldLeadTarget());
        init.setLocation(this.parameters.getInitialLocation());
        init.setRotation(this.parameters.getInitialRotation());
        return init;
    }

    @Override
    public void beforeFirstLogic() {
        this.targetSelector.add(new NearestEnemy().setContext(this));
        this.lookSelector.add(new NearestEnemy().setContext(this));
        this.weaponPrefs.addGeneralPref(ItemType.SHOCK_RIFLE, false);
        this.weaponPrefs.addGeneralPref(ItemType.ROCKET_LAUNCHER, true);
        this.weaponPrefs.addGeneralPref(ItemType.FLAK_CANNON, true);
        this.weaponPrefs.addGeneralPref(ItemType.SNIPER_RIFLE, true);
        this.weaponPrefs.addGeneralPref(ItemType.LIGHTNING_GUN, true);
        this.weaponPrefs.addGeneralPref(ItemType.MINIGUN, true);
        this.weaponPrefs.addGeneralPref(ItemType.LINK_GUN, true);
        this.weaponPrefs.addGeneralPref(ItemType.BIO_RIFLE, false);
        this.weaponPrefs.addGeneralPref(ItemType.ASSAULT_RIFLE, true);
        this.weaponPrefs.addGeneralPref(ItemType.ASSAULT_RIFLE, false);
        this.weaponPrefs.addGeneralPref(ItemType.SHIELD_GUN, false);
        this.weaponPrefs.addGeneralPref(ItemType.SHIELD_GUN, true);
    }

    @Override
    public void logic() {
        ContextSelector selector;
        ContextSelector selector2;
        super.logic();
        while (!this.actions.isEmpty()) {
            ((Action)this.actions.remove()).execute();
        }
        ILocated shootSelected = null;
        Iterator<ContextSelector> i$ = this.targetSelector.iterator();
        while (i$.hasNext() && (shootSelected = (ILocated)(selector2 = i$.next()).select(this.players.getVisiblePlayers().values())) == null) {
        }
        this.weaponShooting.shoot(shootSelected);
        ILocated lookSelected = null;
        Iterator<ContextSelector> i$2 = this.lookSelector.iterator();
        while (i$2.hasNext() && (lookSelected = (ILocated)(selector = i$2.next()).select(this.players.getVisiblePlayers().values())) == null) {
        }
        this.lookFocus.setFocus(lookSelected);
        if (!this.navigation.isNavigating()) {
            if (this.focus.getLocation() != null) {
                this.move.turnTo(this.focus.getLocation());
            } else {
                this.move.turnHorizontal(30);
            }
        }
        ++this.logicIteration;
        try {
            this.percepts.updatePercepts();
        }
        catch (PerceiveException e) {
            throw new PogamutException("Could not update percepts", e);
        }
    }

    public void addAction(Action action) {
        this.actions.add(action);
    }

    public Map<Method, Object> getAllPercepts() {
        return this.percepts.getAllPercepts();
    }

    @AsAction(name="navigate")
    public void navigate(final UnrealIdOrLocation destination) {
        this.log.info(String.format("navigate to %s called", destination));
        this.addAction(new Action(){

            @Override
            public void execute() {
                if (destination.isLocation()) {
                    UT2004BotBehavior.this.log.info(String.format("navigate to %s executed", destination.getLocation()));
                    UT2004BotBehavior.this.navigation.navigate(destination.getLocation());
                    return;
                }
                UnrealId id = destination.getId();
                IWorldObject object = UT2004BotBehavior.this.world.get(id);
                if (object instanceof ILocated) {
                    UT2004BotBehavior.this.navigation.navigate((ILocated)((Object)object));
                    UT2004BotBehavior.this.log.info(String.format("navigate to %s executed", object));
                    return;
                }
                UT2004BotBehavior.this.log.warning(String.format("failed to navigate to %s. Halting.", object));
                UT2004BotBehavior.this.navigation.stopNavigation();
            }
        });
    }

    @AsAction(name="continue")
    public void continueAction(final UnrealIdOrLocation destination) {
        this.log.info(String.format("continue to %s called", destination));
        this.addAction(new Action(){

            @Override
            public void execute() {
                if (destination.isLocation()) {
                    UT2004BotBehavior.this.log.info(String.format("continue to %s executed", destination.getLocation()));
                    UT2004BotBehavior.this.navigation.setContinueTo(destination.getLocation());
                    return;
                }
                UnrealId id = destination.getId();
                IWorldObject object = UT2004BotBehavior.this.world.get(id);
                if (object instanceof ILocated) {
                    UT2004BotBehavior.this.navigation.setContinueTo((ILocated)((Object)object));
                    UT2004BotBehavior.this.log.info(String.format("continue to %s executed", object));
                    return;
                }
                UT2004BotBehavior.this.log.warning(String.format("failed to continue to %s. Halting.", object));
                UT2004BotBehavior.this.navigation.stopNavigation();
            }
        });
    }

    @AsAction(name="stop")
    public void stop() {
        this.log.info("stop called");
        this.addAction(new Action(){

            @Override
            public void execute() {
                UT2004BotBehavior.this.log.info("stop executed");
                UT2004BotBehavior.this.navigation.stopNavigation();
            }
        });
    }

    @AsAction(name="respawn")
    public void respawn() {
        this.log.info("respawn called");
        this.addAction(new Action(){

            @Override
            public void execute() {
                UT2004BotBehavior.this.log.info("respawn executed");
                UT2004BotBehavior.this.bot.respawn();
            }
        });
    }

    @AsAction(name="combo")
    public void combo(final Combo combo) {
        this.log.info("combo %s called", (Object)combo);
        this.addAction(new Action(){

            @Override
            public void execute() {
                if (UT2004BotBehavior.this.info.isAdrenalineSufficient().booleanValue()) {
                    UT2004BotBehavior.this.log.info("combo %s executed", (Object)combo);
                    UT2004BotBehavior.this.body.getAction().startCombo(combo.toString());
                } else {
                    UT2004BotBehavior.this.log.warning("combo %s failed, insufficient adrenaline", (Object)combo);
                }
            }
        });
    }

    @AsAction(name="dropWeapon")
    public void dropWeapon() {
        this.log.info("drop called");
        this.addAction(new Action(){

            @Override
            public void execute() {
                Weapon weapon = UT2004BotBehavior.this.weaponry.getCurrentWeapon();
                UT2004BotBehavior.this.body.getAction().throwWeapon();
                if (weapon == null) {
                    UT2004BotBehavior.this.log.warning(String.format("Could not drop weapon. Not holding a weapon.", new Object[0]));
                } else if (weapon.getType() == ItemType.SHIELD_GUN || weapon.getType() == ItemType.TRANSLOCATOR) {
                    UT2004BotBehavior.this.log.warning(String.format("Could not drop weapon %s", weapon));
                } else {
                    UT2004BotBehavior.this.log.info("drop %s executed", weapon);
                }
            }
        });
    }

    @AsAction(name="path")
    public Percept path(NavPoint from, NavPoint to) {
        this.log.info(String.format("path from  %s to %s executed", from, to));
        double distance = this.fwMap.getDistance(from, to);
        List<NavPoint> navPoints = this.fwMap.getPath(from, to);
        ArrayList<UnrealId> unrealIds = new ArrayList<UnrealId>(navPoints.size());
        for (NavPoint n : navPoints) {
            unrealIds.add(n.getId());
        }
        return new Percept(distance, unrealIds);
    }

    @AsAction(name="shoot")
    public void shoot(final SelectorList targets) {
        this.log.info(String.format("target %s called", targets));
        this.addAction(new Action(){

            @Override
            public void execute() {
                UT2004BotBehavior.this.log.info(String.format("target %s executed", UT2004BotBehavior.this.targetSelector));
                UT2004BotBehavior.this.targetSelector = targets.setContext(UT2004BotBehavior.this);
            }
        });
    }

    public void stopShooting() {
        this.shoot(new SelectorList());
    }

    @AsAction(name="prefer")
    public void prefer(final WeaponPrefList weaponList) {
        this.log.info(String.format("prefer %s called", weaponList));
        this.addAction(new Action(){

            @Override
            public void execute() {
                UT2004BotBehavior.this.weaponPrefs.clearAllPrefs();
                for (WeaponPref pref : weaponList) {
                    UT2004BotBehavior.this.weaponPrefs.addGeneralPref(pref.getWeapon(), pref.isPrimary());
                }
                UT2004BotBehavior.this.log.info(String.format("prefer %s executed", weaponList));
            }
        });
    }

    @AsAction(name="look")
    public void look(final SelectorList targets) {
        this.log.info(String.format("look %s called", targets));
        this.addAction(new Action(){

            @Override
            public void execute() {
                UT2004BotBehavior.this.log.info(String.format("look %s executed", targets));
                UT2004BotBehavior.this.lookSelector = targets.setContext(UT2004BotBehavior.this);
            }
        });
    }

    @AsAction(name="skip")
    public void skip() {
    }

    @AsAction(name="cheatAdrenaline")
    public void cheatAdrenaline() {
        this.getAct().act(new AddInventory().setType(ItemType.ADRENALINE_PACK.getName()));
    }

    @AsPercept(name="navigation", filter=Filter.Type.ON_CHANGE)
    public Percept navigation() {
        return new Percept(new Object[]{this.navigation.getState().getFlag(), this.navigation.getCurrentTarget(), this.navigation.getContinueTo()});
    }

    @AsPercept(name="self", filter=Filter.Type.ON_CHANGE)
    public Percept self() {
        return new Percept(new Object[]{this.info.getId(), this.info.getName(), Team.valueOf(this.info.getTeam())});
    }

    @AsPercept(name="logic", filter=Filter.Type.ON_CHANGE)
    public Percept logicIteration() {
        return new Percept(this.logicIteration);
    }

    @AsPercept(name="orientation", filter=Filter.Type.ON_CHANGE)
    public Percept orientation() {
        return new Percept(this.info.getLocation(), this.info.getRotation(), this.info.getVelocity());
    }

    @AsPercept(name="status", filter=Filter.Type.ON_CHANGE)
    public Percept status() {
        return new Percept(new Object[]{this.info.getHealth(), this.info.getArmor(), this.info.getAdrenaline(), Combo.parseCombo(this.info.getSelf().getCombo())});
    }

    @AsPercept(name="score", filter=Filter.Type.ON_CHANGE)
    public Percept score() {
        return new Percept(this.info.getKills(), this.info.getDeaths(), this.info.getSuicides());
    }

    @AsPercept(name="currentWeapon", filter=Filter.Type.ON_CHANGE)
    public Percept currentWeapon() {
        Weapon weapon = this.weaponry.getCurrentWeapon();
        if (weapon == null) {
            return new Percept(new Object[]{new None(), FireMode.NONE});
        }
        return new Percept(weapon.getType(), FireMode.valueOf(this.info.isPrimaryShooting(), this.info.isSecondaryShooting()));
    }

    @AsPercept(name="weapon", multiplePercepts=true, filter=Filter.Type.ON_CHANGE_NEG)
    public Collection<Percept> weapon() {
        Collection<Weapon> weapons = this.weaponry.getWeapons().values();
        ArrayList<Percept> percepts = new ArrayList<Percept>(weapons.size());
        for (Weapon w : weapons) {
            if (w.getType() == ItemType.SHIELD_GUN) {
                percepts.add(new Percept(w.getType(), 1, w.getSecondaryAmmo()));
                continue;
            }
            percepts.add(new Percept(w.getType(), w.getPrimaryAmmo(), w.getSecondaryAmmo()));
        }
        return percepts;
    }

    private void fraggedEvent(double time2, UnrealId killer, UnrealId victem, String weaponName) {
        this.fragged.add(new Percept(time2, killer, victem, ItemType.getItemType(weaponName)));
    }

    @EventListener(eventClass=BotKilled.class)
    public void msgBotKilled(BotKilled msg) {
        this.fraggedEvent(msg.getSimTime(), msg.getKiller(), this.info.getId(), msg.getWeaponName());
    }

    @EventListener(eventClass=PlayerKilled.class)
    public void msgPlayerKilled(PlayerKilled msg) {
        this.fraggedEvent(msg.getSimTime(), msg.getKiller(), msg.getId(), msg.getWeaponName());
    }

    @AsPercept(name="fragged", multiplePercepts=true, filter=Filter.Type.ALWAYS, event=true)
    public List<Percept> fragged() {
        ArrayList<Percept> percepts = new ArrayList<Percept>(this.fragged);
        this.fragged.clear();
        return percepts;
    }

    @AsPercept(name="navPoint", multiplePercepts=true, filter=Filter.Type.ONCE)
    public Collection<Percept> navPoint() {
        Collection<NavPoint> navPoints = this.world.getAll(NavPoint.class).values();
        ArrayList<Percept> percepts = new ArrayList<Percept>(navPoints.size());
        for (NavPoint p : navPoints) {
            percepts.add(new Percept(p.getId(), p.getLocation(), p.getOutgoingEdges().keySet()));
        }
        return percepts;
    }

    @AsPercept(name="navPoint", multiplePercepts=true, filter=Filter.Type.ON_CHANGE_NEG)
    public Collection<Percept> visibleNavPoint() {
        Collection<NavPoint> navPoints = this.world.getAll(NavPoint.class).values();
        ArrayList<Percept> percepts = new ArrayList<Percept>(navPoints.size());
        for (NavPoint p : navPoints) {
            if (!p.isVisible()) continue;
            percepts.add(new Percept(p.getId(), p.getLocation(), p.getOutgoingEdges().keySet()));
        }
        return percepts;
    }

    @AsPercept(name="pickup", multiplePercepts=true, filter=Filter.Type.ONCE)
    public Collection<Percept> pickup() {
        Collection<Item> pickups = this.items.getKnownPickups().values();
        ArrayList<Percept> percepts = new ArrayList<Percept>(pickups.size());
        for (Item item : pickups) {
            if (item.isDropped()) continue;
            percepts.add(new Percept(new Object[]{item.getNavPoint().getId(), item.getType().getCategory(), item.getType()}));
        }
        return percepts;
    }

    @AsPercept(name="base", multiplePercepts=true, filter=Filter.Type.ONCE)
    public List<Percept> base() {
        ArrayList<Percept> base = new ArrayList<Percept>(2);
        Collection<NavPoint> navPoints = this.world.getAll(NavPoint.class).values();
        NavPoint nav = DistanceUtils.getNearest(navPoints, this.game.getFlagBase(0));
        assert (nav != null);
        base.add(new Percept(new Object[]{Team.RED, nav.getId()}));
        nav = DistanceUtils.getNearest(navPoints, this.game.getFlagBase(1));
        assert (nav != null);
        base.add(new Percept(new Object[]{Team.BLUE, nav.getId()}));
        return base;
    }

    @AsPercept(name="game", filter=Filter.Type.ON_CHANGE)
    public Percept game() {
        return new Percept(new Object[]{this.game.getGameType(), this.game.getMapName(), this.game.getTeamScoreLimit(), this.game.getRemainingTime()});
    }

    @AsPercept(name="teamScore", filter=Filter.Type.ON_CHANGE)
    public Percept teamScore() {
        return new Percept(this.game.getTeamScore(this.info.getTeam()), this.game.getTeamScore(1 - this.info.getTeam()));
    }

    @AsPercept(name="flagState", multiplePercepts=true, filter=Filter.Type.ON_CHANGE_NEG)
    public List<Percept> flagState() {
        ArrayList<Percept> percepts = new ArrayList<Percept>(2);
        percepts.add(new Percept(new Object[]{Team.RED, FlagState.valueOfIgnoreCase(this.game.getFlag(Team.RED.id()).getState())}));
        percepts.add(new Percept(new Object[]{Team.BLUE, FlagState.valueOfIgnoreCase(this.game.getFlag(Team.BLUE.id()).getState())}));
        return percepts;
    }

    @AsPercept(name="item", multiplePercepts=true, filter=Filter.Type.ON_CHANGE_NEG)
    public Collection<Percept> item() {
        Collection<Item> visibleItems = this.items.getVisibleItems().values();
        ArrayList<Percept> percepts = new ArrayList<Percept>(visibleItems.size());
        for (Item item : visibleItems) {
            if (item.isDropped()) {
                percepts.add(new Percept(new Object[]{item.getId(), item.getType().getCategory(), item.getType(), item.getLocation()}));
                continue;
            }
            percepts.add(new Percept(new Object[]{item.getId(), item.getType().getCategory(), item.getType(), item.getNavPointId()}));
        }
        return percepts;
    }

    @AsPercept(name="flag", multiplePercepts=true, filter=Filter.Type.ON_CHANGE_NEG)
    public Collection<Percept> flag() {
        Collection<FlagInfo> flags = this.game.getAllCTFFlagsCollection();
        ArrayList<Percept> percepts = new ArrayList<Percept>(flags.size());
        for (FlagInfo flag : flags) {
            if (!flag.isVisible()) continue;
            percepts.add(new Percept(new Object[]{Team.valueOf(flag.getTeam()), flag.getHolder(), flag.getLocation()}));
        }
        return percepts;
    }

    @AsPercept(name="bot", multiplePercepts=true, filter=Filter.Type.ON_CHANGE_NEG)
    public Collection<Percept> bot() {
        Collection<Player> visible = this.players.getVisiblePlayers().values();
        ArrayList<Percept> wrapped = new ArrayList<Percept>(visible.size());
        for (Player p : visible) {
            wrapped.add(new Percept(new Object[]{p.getId(), p.getName(), Team.valueOf(p.getTeam()), p.getLocation(), ItemType.getItemType(p.getWeapon()), FireMode.valueOf(p.getFiring())}));
        }
        return wrapped;
    }
}

