/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.test;

import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.StopWatch;
import cz.cuni.amis.utils.test.ContextRunnable;
import cz.cuni.amis.utils.test.TestContext;
import java.util.logging.Logger;

public class Repeater<CONTEXT extends TestContext>
implements ContextRunnable<CONTEXT> {
    private int repetitions;
    private ContextRunnable test;

    public Repeater(int repetitions, ContextRunnable test) {
        this.test = test;
        NullCheck.check(this.test, "test");
        this.repetitions = repetitions;
        if (this.repetitions <= 0) {
            throw new IllegalArgumentException("repetitions must be > 0");
        }
    }

    protected Runnable newTestIteration(CONTEXT ctx) {
        return new Runnable((TestContext)ctx){
            final /* synthetic */ TestContext val$ctx;
            {
                this.val$ctx = testContext;
            }

            @Override
            public void run() {
                Repeater.this.test.run(this.val$ctx);
            }
        };
    }

    @Override
    public void run(CONTEXT ctx) {
        Logger log = ((TestContext)ctx).getLog();
        double totalMillis = 0.0;
        StopWatch watch = new StopWatch();
        for (int i = 0; i < this.repetitions; ++i) {
            log.log(log.getLevel(), "---((( Run " + (i + 1) + " / " + this.repetitions + " )))---");
            watch.start();
            this.newTestIteration(ctx).run();
            totalMillis += watch.stop();
        }
        log.log(log.getLevel(), String.format("All " + this.repetitions + " tests finished in %.3f ms.", totalMillis));
    }
}

